/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.propertyset.JiraCachingPropertySet;
import com.atlassian.jira.propertyset.JiraCachingPropertySetManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;

@EventComponent
public class DefaultJiraCachingPropertySetManager
implements JiraCachingPropertySetManager {
    @ClusterSafe(value="This class is basically not cluster safe anyway and is not / should not be used directly ")
    private final Collection<JiraCachingPropertySet> propertySets = Collections.newSetFromMap(new WeakHashMap());

    @Override
    @ClusterSafe(value="This class is basically not cluster safe anyway and is not / should not be used directly ")
    public synchronized void register(JiraCachingPropertySet propertySet) {
        if (propertySet != null) {
            this.propertySets.add(propertySet);
        }
    }

    @EventListener
    @ClusterSafe(value="This class is basically not cluster safe anyway and is not / should not be used directly ")
    public synchronized void onClearCache(ClearCacheEvent clearCacheEvent) {
        for (JiraCachingPropertySet propertySet : this.propertySets) {
            propertySet.clearCache();
        }
    }

    @VisibleForTesting
    @ClusterSafe(value="This class is basically not cluster safe anyway and is not / should not be used directly ")
    synchronized Collection<JiraCachingPropertySet> getManagedPropertySets() {
        return new ArrayList<JiraCachingPropertySet>(this.propertySets);
    }
}

