/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.reactions;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ReactionSummary {
    public final long commentId;
    public final String emojiId;
    public final int count;
    public final boolean reacted;
    public final String[] users;

    public ReactionSummary(long commentId, String emojiId, int count, boolean reacted, @Nonnull String[] users) {
        this.commentId = commentId;
        this.emojiId = Objects.requireNonNull(emojiId);
        this.count = count;
        this.reacted = reacted;
        this.users = Objects.requireNonNull(users);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactionSummary that = (ReactionSummary)o;
        return this.commentId == that.commentId && this.count == that.count && this.reacted == that.reacted && Objects.equals(this.emojiId, that.emojiId) && Arrays.equals(this.users, that.users);
    }

    public int hashCode() {
        int result = Objects.hash(this.commentId, this.emojiId, this.count, this.reacted);
        result = 31 * result + Arrays.hashCode(this.users);
        return result;
    }

    public String toString() {
        return "ReactionSummary{commentId=" + this.commentId + ", emojiId='" + this.emojiId + '\'' + ", count=" + this.count + ", reacted=" + this.reacted + ", users=" + Arrays.toString(this.users) + '}';
    }
}

