/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.render;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.render.Encoder;
import com.atlassian.jira.render.NoOpEncoder;
import com.atlassian.jira.render.StrictEncoder;
import com.atlassian.jira.web.HttpRequestLocal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SwitchingEncoder
implements Encoder {
    private final ApplicationProperties applicationProperties;
    private final HttpRequestLocal<Encoder> requestEncoder = new HttpRequestLocal<Encoder>(SwitchingEncoder.class.getName()){

        @Override
        protected Encoder initialValue() {
            return SwitchingEncoder.this.createEncoder();
        }
    };

    public SwitchingEncoder(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Nonnull
    public String encodeForHtml(@Nullable Object input) {
        Encoder encoder = this.requestEncoder.get();
        if (encoder == null) {
            encoder = this.createEncoder();
        }
        return encoder.encodeForHtml(input);
    }

    @Nonnull
    protected Encoder createEncoder() {
        if (this.applicationProperties.getOption("jira.custom.field.html.enabled")) {
            return new NoOpEncoder();
        }
        return new StrictEncoder();
    }
}

