/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class ActionInvocationCheckerBase {
    private static final String EXECUTE_METHOD_NAME = "doExecute";
    private static final String METHOD_PREFIX = "do";

    protected String getMethodName(String command) {
        if (StringUtils.isBlank((CharSequence)command)) {
            return EXECUTE_METHOD_NAME;
        }
        return METHOD_PREFIX + StringUtils.capitalize((String)command);
    }

    protected Method getMethod(Class<?> clazz, String methodName) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return this.getMethod(clazz.getSuperclass(), methodName);
        }
    }
}

