/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.JiraPluginCacheResetEvent;
import com.atlassian.jira.security.plugin.ProjectPermissionOverrideModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collection;
import java.util.List;

public class ProjectPermissionOverrideDescriptorCache
implements Startable {
    private EventPublisher eventPublisher;
    private ResettableLazyReference<List<ProjectPermissionOverrideModuleDescriptor>> enabledModuleDescriptors;

    public ProjectPermissionOverrideDescriptorCache(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.enabledModuleDescriptors = new ResettableLazyReference<List<ProjectPermissionOverrideModuleDescriptor>>(){

            protected List<ProjectPermissionOverrideModuleDescriptor> create() throws Exception {
                return ImmutableList.copyOf((Collection)ComponentAccessor.getPluginAccessor().getEnabledModuleDescriptorsByClass(ProjectPermissionOverrideModuleDescriptor.class));
            }
        };
    }

    @EventListener
    public void onJiraPluginCacheResetEvent(JiraPluginCacheResetEvent event) {
        if (event.hasAnyEventWithModuleDescriptorMatching(ProjectPermissionOverrideModuleDescriptor.class::isInstance)) {
            this.reloadCache();
        }
    }

    public List<ProjectPermissionOverrideModuleDescriptor> getProjectPermissionOverrideDescriptors() {
        return (List)this.enabledModuleDescriptors.get();
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @VisibleForTesting
    protected synchronized void reloadCache() {
        this.enabledModuleDescriptors.reset();
    }
}

