/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.atlassian.jira.user.ApplicationUser;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Option;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SubvertedPermissionManager
implements PermissionManager {
    public Collection<ProjectPermission> getAllProjectPermissions() {
        return ((ProjectPermissionTypesManager)ComponentAccessor.getComponent(ProjectPermissionTypesManager.class)).all();
    }

    public Collection<ProjectPermission> getProjectPermissions(@Nonnull ProjectPermissionCategory category) {
        return ((ProjectPermissionTypesManager)ComponentAccessor.getComponent(ProjectPermissionTypesManager.class)).withCategory(category);
    }

    public Option<ProjectPermission> getProjectPermission(@Nonnull ProjectPermissionKey permissionKey) {
        return ((ProjectPermissionTypesManager)ComponentAccessor.getComponent(ProjectPermissionTypesManager.class)).withKey(permissionKey);
    }

    public Collection<Project> getProjects(int permissionId, ApplicationUser user) {
        return this.getProjects();
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.getProjects();
    }

    private Collection<Project> getProjects() {
        return ComponentAccessor.getProjectManager().getProjectObjects();
    }

    public Collection<Project> getProjects(int permissionId, ApplicationUser user, ProjectCategory projectCategory) {
        return this.getProjectsWithCategory(projectCategory);
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user, @Nullable ProjectCategory projectCategory) {
        return this.getProjectsWithCategory(projectCategory);
    }

    public Collection<Project> getArchivedProjects(@Nonnull ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.getArchivedProjects();
    }

    private Collection<Project> getArchivedProjects() {
        return ComponentAccessor.getProjectManager().getArchivedProjects();
    }

    public void flushCache() {
    }

    private Collection<Project> getProjectsWithCategory(ProjectCategory category) {
        if (category == null) {
            return ComponentAccessor.getProjectManager().getProjectObjectsWithNoCategory();
        }
        return ComponentAccessor.getProjectManager().getProjectsFromProjectCategory(category);
    }

    public boolean hasProjects(int permissionId, ApplicationUser user) {
        return this.hasProjects();
    }

    public boolean hasProjects(@Nonnull ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.hasProjects();
    }

    private boolean hasProjects() {
        return !this.getProjects().isEmpty();
    }

    public void removeGroupPermissions(String group) {
        throw new UnsupportedOperationException("removeGroupPermissions() not implemented in " + this.getClass().getName());
    }

    public void removeUserPermissions(ApplicationUser user) throws RemoveException {
        throw new UnsupportedOperationException("removeUserPermissions() not implemented in " + this.getClass().getName());
    }

    public Collection<Group> getAllGroups(int permType, Project project) {
        throw new UnsupportedOperationException("getAllGroups() not implemented in " + this.getClass().getName());
    }

    public boolean hasPermission(int permissionsId, ApplicationUser user) {
        return true;
    }

    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        return true;
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, ApplicationUser user) {
        return true;
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        return true;
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nonnull Status status) {
        return true;
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        return true;
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return true;
    }

    @Nonnull
    public ProjectWidePermission hasProjectWidePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return ProjectWidePermission.ALL_ISSUES;
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        return true;
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, ApplicationUser user, boolean issueCreation) {
        return true;
    }
}

