/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;
import webwork.action.CommandDriven;

public class WebworkActionFailureException
extends RuntimeException {
    private final Action action;

    public static String getActionAndCommandNameIfAvailable(Action action) {
        String actionName = action.getClass().getName();
        if (action instanceof CommandDriven) {
            String commandName = ((CommandDriven)action).getCommandName();
            if (StringUtils.isNotBlank((CharSequence)commandName)) {
                return actionName + "!" + commandName;
            }
            return actionName + "!execute";
        }
        return actionName;
    }

    public WebworkActionFailureException(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public String getActionAndCommandNameIfAvailable() {
        return WebworkActionFailureException.getActionAndCommandNameIfAvailable(this.getAction());
    }
}

