/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.login.XsrfTokenAppendingResponse;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.seraph.logout.LogoutServlet;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JiraLogoutServlet
extends HttpServlet {
    static final String ALREADY_LOGGED_OUT_PAGE = "/alreadyloggedout.jsp";
    static final String LOG_OUT_CONFIRM_PAGE = "/logoutconfirm.jsp";
    private final HttpServlet seraphLogoutServlet = new LogoutServlet();

    public void init() throws ServletException {
        this.getSeraphLogoutServlet().init();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.getSeraphLogoutServlet().init(servletConfig);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XsrfInvocationChecker invocationChecker = this.getXsrfInvocationChecker();
        XsrfCheckResult result = invocationChecker.checkWebRequestInvocation(request);
        if (result.isValid()) {
            XsrfTokenAppendingResponse wrappedResponse = this.createXsrfTokenAppendingResponse(request, response);
            this.getSeraphLogoutServlet().service((ServletRequest)request, (ServletResponse)wrappedResponse);
        } else if (!result.isOriginAllowed()) {
            response.sendError(403);
        } else if (this.isUserAuthenticated()) {
            response.sendRedirect(request.getContextPath() + LOG_OUT_CONFIRM_PAGE);
        } else {
            response.sendRedirect(request.getContextPath() + ALREADY_LOGGED_OUT_PAGE);
        }
    }

    public ServletConfig getServletConfig() {
        return this.getSeraphLogoutServlet().getServletConfig();
    }

    public void destroy() {
        super.destroy();
    }

    boolean isUserAuthenticated() {
        return this.getAuthenticationContext().getUser() != null;
    }

    JiraAuthenticationContext getAuthenticationContext() {
        return (JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class);
    }

    XsrfTokenAppendingResponse createXsrfTokenAppendingResponse(HttpServletRequest request, HttpServletResponse response) {
        return new XsrfTokenAppendingResponse(request, response);
    }

    XsrfInvocationChecker getXsrfInvocationChecker() {
        return (XsrfInvocationChecker)ComponentAccessor.getComponentOfType(XsrfInvocationChecker.class);
    }

    HttpServlet getSeraphLogoutServlet() {
        return this.seraphLogoutServlet;
    }
}

