/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.handlers.UserEventHandler;
import com.atlassian.jira.bc.security.login.CaptchaChallengeRequired;
import com.atlassian.jira.bc.security.login.DeniedReason;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginInfoImpl;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.bc.security.login.LoginReason;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginResultImpl;
import com.atlassian.jira.event.user.LoginEvent;
import com.atlassian.jira.event.user.LoginFailedEvent;
import com.atlassian.jira.event.user.LogoutEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.auth.AuthorisationManager;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.security.login.LoginStore;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.google.common.collect.Sets;
import com.octo.captcha.service.CaptchaServiceException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;
import webwork.action.factory.SessionMap;

public class LoginManagerImpl
implements LoginManager {
    private static final Logger log = LoggerFactory.getLogger(LoginManagerImpl.class);
    private static final org.apache.log4j.Logger loggerSecurityEvents = LoginLoggers.LOGIN_SECURITY_EVENTS;
    public static final String AUTHORISED_FAILURE = new String("com.atlassian.jira.security.login.LoginManager.AUTHORISED_FAILURE");
    public static final String AUTHORISING_USER_KEY = new String("com.atlassian.jira.security.login.LoginManager.AUTHORISING_USER_KEY");
    private static final String ELEVATED_SECURITY_FAILURE = "com.atlassian.jira.security.login.LoginManager.ELEVATED_SECURITY_FAILURE";
    private static final String OS_CAPTCHA = "os_captcha";
    private static final String OS_DESTINATION = "os_destination";
    private final LoginStore loginStore;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CrowdService crowdService;
    private final StaticDependencies staticDependencies;
    private final JiraCaptchaService jiraCaptchaService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final EventPublisher eventPublisher;
    private final AuthorisationManager authorisationManager;
    private final UserEventHandler userEventHandler;

    public LoginManagerImpl(LoginStore loginStore, JiraAuthenticationContext jiraAuthenticationContext, CrowdService crowdService, JiraCaptchaService jiraCaptchaService, VelocityRequestContextFactory velocityRequestContextFactory, EventPublisher eventPublisher, AuthorisationManager authorisationManager, UserEventHandler userEventHandler) {
        this(new InternalStaticDependencies(crowdService), loginStore, jiraAuthenticationContext, crowdService, jiraCaptchaService, velocityRequestContextFactory, eventPublisher, authorisationManager, userEventHandler);
    }

    LoginManagerImpl(StaticDependencies staticDependencies, LoginStore loginStore, JiraAuthenticationContext jiraAuthenticationContext, CrowdService crowdService, JiraCaptchaService jiraCaptchaService, VelocityRequestContextFactory velocityRequestContextFactory, EventPublisher eventPublisher, AuthorisationManager authorisationManager, UserEventHandler userEventHandler) {
        this.loginStore = (LoginStore)Assertions.notNull((String)"loginStore", (Object)loginStore);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"jiraAuthenticationContext", (Object)jiraAuthenticationContext);
        this.crowdService = (CrowdService)Assertions.notNull((String)"crowdService", (Object)crowdService);
        this.jiraCaptchaService = (JiraCaptchaService)Assertions.notNull((String)"jiraCaptchaService", (Object)jiraCaptchaService);
        this.staticDependencies = (StaticDependencies)Assertions.notNull((String)"staticDependencies", (Object)staticDependencies);
        this.velocityRequestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"velocityRequestContextFactory", (Object)velocityRequestContextFactory);
        this.eventPublisher = eventPublisher;
        this.authorisationManager = authorisationManager;
        this.userEventHandler = userEventHandler;
    }

    @Override
    public LoginInfo getLoginInfo(String userName) {
        ApplicationUser user = ApplicationUsers.from(this.crowdService.getUser(userName));
        if (user == null) {
            return null;
        }
        LoginInfo storedLoginInfo = this.loginStore.getLoginInfo(user);
        return this.tweakLoginInfo(storedLoginInfo);
    }

    @Override
    public boolean performElevatedSecurityCheck(HttpServletRequest httpServletRequest, String userName) {
        boolean captchOK;
        Boolean isResponseCorrect;
        httpServletRequest.removeAttribute(ELEVATED_SECURITY_FAILURE);
        LoginInfo loginInfo = this.getLoginInfo(userName);
        if (loginInfo == null) {
            return true;
        }
        if (!loginInfo.isElevatedSecurityCheckRequired()) {
            return true;
        }
        String captcha = httpServletRequest.getParameter(OS_CAPTCHA);
        String sessionId = httpServletRequest.getSession(true).getId();
        try {
            isResponseCorrect = this.jiraCaptchaService.getImageCaptchaService().validateResponseForID(sessionId, (Object)captcha);
        }
        catch (CaptchaServiceException e) {
            isResponseCorrect = false;
        }
        boolean bl = captchOK = isResponseCorrect == null || isResponseCorrect != false;
        if (!captchOK) {
            httpServletRequest.setAttribute(ELEVATED_SECURITY_FAILURE, (Object)true);
        }
        return captchOK;
    }

    @Override
    public boolean authoriseForLogin(@Nonnull ApplicationUser user, HttpServletRequest httpServletRequest) {
        Assertions.notNull((String)"user", (Object)user);
        httpServletRequest.removeAttribute(AUTHORISED_FAILURE);
        httpServletRequest.setAttribute(AUTHORISING_USER_KEY, (Object)user.getKey());
        boolean authorised = this.authorisationManager.authoriseForLogin(user, httpServletRequest);
        if (!authorised) {
            httpServletRequest.setAttribute(AUTHORISED_FAILURE, (Object)true);
        }
        return authorised;
    }

    @Override
    public Set<String> getRequiredRoles(HttpServletRequest httpServletRequest) {
        return this.authorisationManager.getRequiredRoles(httpServletRequest);
    }

    @Override
    public boolean authoriseForRole(@Nullable ApplicationUser user, HttpServletRequest httpServletRequest, String role) {
        httpServletRequest.removeAttribute(AUTHORISED_FAILURE);
        boolean authorised = this.authorisationManager.authoriseForRole(user, httpServletRequest, role);
        if (!authorised) {
            httpServletRequest.setAttribute(AUTHORISED_FAILURE, (Object)true);
        }
        return authorised;
    }

    @Override
    public LoginResult authenticate(ApplicationUser user, String password) {
        Assertions.notNull((String)"user", (Object)user);
        String userName = user.getName();
        LoginInfo loginInfo = this.getLoginInfo(userName);
        LoginReason reason = loginInfo.isElevatedSecurityCheckRequired() ? LoginReason.AUTHENTICATION_DENIED : (this.staticDependencies.authenticate(user, password) ? LoginReason.OK : LoginReason.AUTHENTICATED_FAILED);
        loginInfo = this.tweakLoginInfo(this.recordLoginAttempt(user, reason == LoginReason.OK));
        this.logSecurityEvents(user, loginInfo, reason);
        return new LoginResultImpl(reason, loginInfo, user.getName());
    }

    @Override
    public LoginResult authenticateWithoutElevatedCheck(ApplicationUser user, String password) {
        Assertions.notNull((String)"user", (Object)user);
        String userName = user.getName();
        LoginReason reason = this.staticDependencies.authenticate(user, password) ? LoginReason.OK : LoginReason.AUTHENTICATED_FAILED;
        LoginInfo loginInfo = this.tweakLoginInfo(this.recordLoginAttempt(user, reason == LoginReason.OK));
        this.logSecurityEvents(user, loginInfo, reason);
        return new LoginResultImpl(reason, loginInfo, userName);
    }

    @Override
    public LoginInfo onLoginAttempt(HttpServletRequest httpServletRequest, String userName, boolean loginSuccessful) {
        LoginReason reason;
        ApplicationUser user = ApplicationUsers.from(this.crowdService.getUser(userName));
        if (user == null) {
            this.userEventHandler.onUnknownUserLoginFailed(userName);
            return null;
        }
        LoginInfo loginInfo = this.tweakLoginInfo(this.recordLoginAttempt(user, loginSuccessful));
        LoginReason loginReason = reason = loginSuccessful ? LoginReason.OK : LoginReason.AUTHENTICATED_FAILED;
        if (!loginSuccessful) {
            if (httpServletRequest.getAttribute(ELEVATED_SECURITY_FAILURE) != null) {
                reason = LoginReason.AUTHENTICATION_DENIED;
            } else if (httpServletRequest.getAttribute(AUTHORISED_FAILURE) != null) {
                reason = LoginReason.AUTHORISATION_FAILED;
            }
        }
        this.recordLoginResultInRequest(httpServletRequest, new LoginResultImpl(reason, loginInfo, userName, this.getLoginDeniedReasons(httpServletRequest)));
        String url = httpServletRequest.getParameter(OS_DESTINATION);
        this.logSecurityEvents(user, loginInfo, reason, url);
        return loginInfo;
    }

    @Override
    public LoginInfo updateLastLoginTime(ApplicationUser user) {
        return this.loginStore.updateLastLoginTime(user);
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        Assertions.notNull((String)"request", (Object)request);
        Assertions.notNull((String)"response", (Object)response);
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getUser();
        String userName = loggedInUser == null ? "unknown" : loggedInUser.getName();
        HttpSession currentSession = request.getSession(false);
        if (currentSession != null) {
            currentSession.invalidate();
        }
        HttpSession newSession = request.getSession(true);
        ActionContext.setSession((Map)new SessionMap(newSession));
        try {
            this.staticDependencies.getAuthenticator().logout(request, response);
        }
        catch (AuthenticatorException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        loggerSecurityEvents.info((Object)("The user '" + userName + "' has logged out."));
        this.jiraAuthenticationContext.clearLoggedInUser();
        request.setAttribute("jira.logout.page.executed", (Object)Boolean.TRUE);
        if (loggedInUser == null) {
            this.userEventHandler.onUnknownUserLoggedOut(userName);
        } else {
            this.userEventHandler.onUserLoggedOut(loggedInUser);
        }
        this.eventPublisher.publish((Object)new LogoutEvent(loggedInUser));
    }

    @Override
    public boolean isElevatedSecurityCheckAlwaysShown() {
        return this.getMaxAuthenticationAttemptsAllowed() <= 0L;
    }

    @Override
    public void resetFailedLoginCount(ApplicationUser user) {
        this.loginStore.resetFailedLoginCount(user);
    }

    protected Set<DeniedReason> getLoginDeniedReasons(HttpServletRequest request) {
        HashSet loginDeniedDueTo = Sets.newHashSet();
        if (request.getAttribute(ELEVATED_SECURITY_FAILURE) != null) {
            String loginJsp = String.format("%s/login.jsp", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
            loginDeniedDueTo.add(new CaptchaChallengeRequired(loginJsp));
        }
        return loginDeniedDueTo;
    }

    private void logSecurityEvents(@Nonnull ApplicationUser user, LoginInfo loginInfo, LoginReason reason) {
        this.logSecurityEvents(user, loginInfo, reason, null);
    }

    private void logSecurityEvents(@Nonnull ApplicationUser user, LoginInfo loginInfo, LoginReason reason, String url) {
        String userName = user.getName();
        if (reason != LoginReason.OK) {
            if (reason == LoginReason.AUTHENTICATION_DENIED) {
                loggerSecurityEvents.warn((Object)("The user '" + userName + "' is required to answer a CAPTCHA elevated security check.  Failure count equals " + loginInfo.getCurrentFailedLoginCount()));
            } else if (reason == LoginReason.AUTHENTICATED_FAILED) {
                loggerSecurityEvents.warn((Object)("The user '" + userName + "' has FAILED authentication.  Failure count equals " + loginInfo.getCurrentFailedLoginCount()));
            } else if (reason == LoginReason.AUTHORISATION_FAILED) {
                loggerSecurityEvents.warn((Object)("The user '" + userName + "' is NOT AUTHORIZED to perform this request"));
            }
            LoginFailedEvent event = new LoginFailedEvent(user, loginInfo, reason, url);
            this.eventPublisher.publish((Object)event);
        } else {
            Log4jKit.putUserToMDC(userName);
            loggerSecurityEvents.info((Object)("The user '" + userName + "' has PASSED authentication."));
            this.eventPublisher.publish((Object)new LoginEvent(user, I18nBean.getLocaleFromUser(user)));
        }
    }

    private LoginInfo recordLoginAttempt(ApplicationUser user, boolean loginSuccessful) {
        return this.loginStore.recordLoginAttempt(user, loginSuccessful);
    }

    private LoginResultImpl recordLoginResultInRequest(HttpServletRequest httpServletRequest, LoginResultImpl loginResult) {
        httpServletRequest.setAttribute("com.atlassian.jira.security.login.LoginManager.LoginResult", (Object)loginResult);
        return loginResult;
    }

    private LoginInfo tweakLoginInfo(LoginInfo storedLoginInfo) {
        long maxLoginAttempts = this.getMaxAuthenticationAttemptsAllowed();
        boolean elevatedSecurityCheckRequired = this.nvl(storedLoginInfo.getCurrentFailedLoginCount(), 0L) >= maxLoginAttempts;
        return LoginInfoImpl.builder(storedLoginInfo).setElevatedSecurityCheckRequired(elevatedSecurityCheckRequired).build();
    }

    private long nvl(Long value, long defaultValue) {
        return value == null ? defaultValue : value;
    }

    private long getMaxAuthenticationAttemptsAllowed() {
        return this.loginStore.getMaxAuthenticationAttemptsAllowed();
    }

    private static class InternalStaticDependencies
    implements StaticDependencies {
        final CrowdService crowdService;

        private InternalStaticDependencies(CrowdService crowdService) {
            this.crowdService = crowdService;
        }

        @Override
        public Authenticator getAuthenticator() {
            return SecurityConfigFactory.getInstance().getAuthenticator();
        }

        @Override
        public boolean authenticate(ApplicationUser user, String password) {
            try {
                return this.crowdService.authenticate(user.getName(), password) != null;
            }
            catch (FailedAuthenticationException e) {
                return false;
            }
        }
    }

    static interface StaticDependencies {
        public Authenticator getAuthenticator();

        public boolean authenticate(ApplicationUser var1, String var2);
    }
}

