/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.properties;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateDao;
import com.atlassian.jira.cluster.zdu.JiraUpgradeApprovedEvent;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.model.querydsl.ClusterUpgradeStateDTO;
import com.atlassian.jira.security.properties.SecurityPropertiesDao;
import com.atlassian.jira.security.properties.SecurityPropertiesService;
import com.atlassian.security.random.SecureRandomFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultSecurityPropertiesService
implements SecurityPropertiesService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecurityPropertiesService.class);
    private static final long CACHE_MAX_SIZE = 1000L;
    private static final long CACHE_EXPIRATION_SECONDS = 30L;
    private static final int DEFAULT_KEY_LENGTH_BYTES = 64;
    private final SecurityPropertiesDao securityPropertiesDao;
    private final ClusterUpgradeStateDao clusterUpgradeStateDao;
    private final Cache<String, Optional<String>> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private AtomicBoolean upgradeStateStable = new AtomicBoolean(false);

    public static String defaultGenerateKey() {
        byte[] secret = new byte[64];
        SecureRandomFactory.newInstance().nextBytes(secret);
        return Base64.getEncoder().encodeToString(secret);
    }

    public DefaultSecurityPropertiesService(SecurityPropertiesDao securityPropertiesDao, ClusterUpgradeStateDao clusterUpgradeStateDao) {
        this.securityPropertiesDao = securityPropertiesDao;
        this.clusterUpgradeStateDao = clusterUpgradeStateDao;
    }

    @Override
    public void invalidate() {
        log.debug("invalidate all");
        this.cache.invalidateAll();
    }

    @Override
    public void invalidate(String key) {
        log.debug("invalidate key: {}", (Object)key);
        this.cache.invalidate((Object)key);
    }

    @Override
    public Optional<String> getSecret(String key) {
        return this.getSecret(key, this::isUpgradeStateStable);
    }

    public Optional<String> getSecret(String key, boolean createIfMissing) {
        return this.getSecretUsingValueCreator(key, createIfMissing ? DefaultSecurityPropertiesService::defaultGenerateKey : () -> null);
    }

    public Optional<String> getSecret(String key, Supplier<Boolean> createIfMissing) {
        return this.getSecretUsingValueCreator(key, () -> (Boolean)createIfMissing.get() != false ? DefaultSecurityPropertiesService.defaultGenerateKey() : null);
    }

    public Optional<String> getSecretUsingValueCreator(String key, Supplier<String> valueCreator) {
        try {
            return (Optional)this.cache.get((Object)key, () -> {
                String value = this.securityPropertiesDao.getOrCreate(key, valueCreator);
                if (value != null && !value.trim().isEmpty()) {
                    log.debug("loaded key: {}", (Object)key);
                    return Optional.of(value);
                }
                log.debug("missing key: {}", (Object)key);
                return Optional.empty();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @EventListener
    public void onImportCompleted(ImportCompletedEvent importCompletedEvent) {
        log.debug("ImportCompletedEvent event");
        this.invalidate();
    }

    @EventListener
    public void onClearCacheEvent(ClearCacheEvent clearCacheEvent) {
        log.debug("ClearCacheEvent event");
        this.invalidate();
    }

    @EventListener
    public void onJiraUpgradedEvent(JiraUpgradedEvent jiraUpgradedEvent) {
        log.debug("JiraUpgradedEvent event");
        this.invalidate();
    }

    @EventListener
    public void onJiraUpgradeApprovedEvent(JiraUpgradeApprovedEvent jiraUpgradeApprovedEvent) {
        log.debug("JiraUpgradeApprovedEvent event");
        this.invalidate();
    }

    private boolean isUpgradeStateStable() {
        if (!this.upgradeStateStable.get()) {
            if (UpgradeState.STABLE.equals((Object)this.getUpgradeState())) {
                this.upgradeStateStable.set(true);
                log.debug("upgrade state is STABLE");
                return true;
            }
            return false;
        }
        return true;
    }

    private UpgradeState getUpgradeState() {
        Optional<ClusterUpgradeStateDTO> currentState = this.clusterUpgradeStateDao.getCurrent();
        return currentState.map(ClusterUpgradeStateDTO::getState).map(UpgradeState::valueOf).orElse(UpgradeState.STABLE);
    }
}

