/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheManager;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.atlassian.jira.security.roles.CachingProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProjectRoleActorsZduSafeCache {
    private final Cache<Long, Map<Optional<Long>, ProjectRoleActors>> oldCache;
    private final Cache<CachingProjectRoleAndActorStore.ProjectRoleMapping, ProjectRoleActors> newCache;

    public ProjectRoleActorsZduSafeCache(CacheManager cacheManager, ReplicationPauserManager replicationPauserManager, String oldCacheName, Cache<CachingProjectRoleAndActorStore.ProjectRoleMapping, ProjectRoleActors> newCache) {
        this.oldCache = cacheManager.getCache(oldCacheName);
        this.newCache = newCache;
        this.oldCache.addListener(ProjectRoleActorsZduSafeCache.invalidationForwarder(newCache, replicationPauserManager), false);
    }

    @Nullable
    public ProjectRoleActors get(@Nonnull CachingProjectRoleAndActorStore.ProjectRoleMapping key) {
        return (ProjectRoleActors)this.newCache.get((Object)key);
    }

    public void remove(@Nonnull CachingProjectRoleAndActorStore.ProjectRoleMapping key) {
        this.oldCache.removeAll();
        this.newCache.remove((Object)key);
    }

    public void removeByProjectId(Long projectId) {
        this.oldCache.removeAll();
        this.newCache.getKeys().stream().filter(projectRoleMapping -> Objects.equals(projectId, projectRoleMapping.getProjectId())).forEach(arg_0 -> this.newCache.remove(arg_0));
    }

    public void removeByRoleId(long roleId) {
        this.oldCache.removeAll();
        this.newCache.getKeys().stream().filter(projectRoleMapping -> projectRoleMapping.getRoleId() == roleId).forEach(arg_0 -> this.newCache.remove(arg_0));
    }

    public void removeAll() {
        this.oldCache.removeAll();
        this.newCache.removeAll();
    }

    private static CacheEntryListener<Long, Map<Optional<Long>, ProjectRoleActors>> invalidationForwarder(final Cache<CachingProjectRoleAndActorStore.ProjectRoleMapping, ProjectRoleActors> newCache, final ReplicationPauserManager replicationPauserManager) {
        return new CacheEntryListener<Long, Map<Optional<Long>, ProjectRoleActors>>(){

            public void onAdd(@Nonnull CacheEntryEvent<Long, Map<Optional<Long>, ProjectRoleActors>> event) {
                this.remove((Long)event.getKey());
            }

            public void onEvict(@Nonnull CacheEntryEvent<Long, Map<Optional<Long>, ProjectRoleActors>> event) {
                this.remove((Long)event.getKey());
            }

            public void onRemove(@Nonnull CacheEntryEvent<Long, Map<Optional<Long>, ProjectRoleActors>> event) {
                this.remove((Long)event.getKey());
            }

            public void onUpdate(@Nonnull CacheEntryEvent<Long, Map<Optional<Long>, ProjectRoleActors>> event) {
                this.remove((Long)event.getKey());
            }

            private void remove(Long projectRoleId) {
                replicationPauserManager.pauseReplicationFor(() -> newCache.getKeys().stream().filter(projectRoleMapping -> projectRoleMapping.getRoleId() == projectRoleId.longValue()).forEach(arg_0 -> ((Cache)newCache).remove(arg_0)), ProjectRoleActorsZduSafeCache.class.getSimpleName());
            }
        };
    }
}

