/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles.actor;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.model.querydsl.QProjectRoleActor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.actor.AbstractRoleActor;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public class GroupRoleActorFactory
implements RoleActorFactory {
    private final GroupManager groupManager;
    private final DbConnectionManager dbConnectionManager;

    public GroupRoleActorFactory(GroupManager groupManager, DbConnectionManager dbConnectionManager) {
        this.groupManager = groupManager;
        this.dbConnectionManager = dbConnectionManager;
    }

    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String groupName) throws RoleActorDoesNotExistException {
        if (!"atlassian-group-role-actor".equals(type)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot create RoleActors of type: " + type);
        }
        return new GroupRoleActor(id, projectRoleId, projectId, groupName);
    }

    public Set<RoleActor> optimizeRoleActorSet(Set<RoleActor> roleActors) {
        return roleActors;
    }

    @Nonnull
    public Set<ProjectRoleActor> getAllRoleActorsForUser(@Nullable ApplicationUser user) {
        if (user == null) {
            return ImmutableSet.of();
        }
        List groupNames = this.groupManager.getGroupNamesForUser(user).stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toList());
        ImmutableSet.Builder resultsBuilder = ImmutableSet.builder();
        this.dbConnectionManager.execute(dbConnection -> {
            QProjectRoleActor pra = new QProjectRoleActor("pra");
            try (CloseableIterator roleActorTuples = ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)Projections.tuple((Expression[])new Expression[]{pra.id, pra.pid, pra.projectroleid, pra.roletype, pra.roletypeparameter})).from((Expression)pra)).where((Predicate)pra.roletype.eq((Object)"atlassian-group-role-actor").and((Predicate)pra.pid.isNotNull()))).iterate();){
                this.addMatchingActors((Iterator<Tuple>)roleActorTuples, pra, groupNames, (ImmutableSet.Builder<ProjectRoleActor>)resultsBuilder);
            }
        });
        return resultsBuilder.build();
    }

    private void addMatchingActors(Iterator<Tuple> roleActorTuples, QProjectRoleActor pra, Collection<String> groupNames, ImmutableSet.Builder<ProjectRoleActor> resultsBuilder) {
        while (roleActorTuples.hasNext()) {
            Tuple tuple = roleActorTuples.next();
            String groupName = IdentifierUtils.toLowerCase((String)((String)tuple.get((Expression)pra.roletypeparameter)));
            if (!groupNames.contains(groupName)) continue;
            GroupRoleActor actor = new GroupRoleActor((Long)tuple.get(pra.id), (Long)tuple.get(pra.projectroleid), (Long)tuple.get(pra.pid), groupName, true);
            resultsBuilder.add((Object)actor);
        }
    }

    public class GroupRoleActor
    extends AbstractRoleActor {
        private volatile Boolean active;

        GroupRoleActor(Long id, Long projectRoleId, Long projectId, String groupName) {
            super(id, projectRoleId, projectId, groupName);
        }

        GroupRoleActor(Long id, Long projectRoleId, Long projectId, String groupName, boolean active) {
            super(id, projectRoleId, projectId, groupName);
            this.active = active;
        }

        public boolean isActive() {
            Boolean active = this.active;
            if (active == null) {
                this.active = active = Boolean.valueOf(GroupRoleActorFactory.this.groupManager.groupExists(this.getParameter()));
            }
            return active;
        }

        public String getType() {
            return "atlassian-group-role-actor";
        }

        public String getDescriptor() {
            return this.getParameter();
        }

        public Set<ApplicationUser> getUsers() {
            HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
            for (ApplicationUser user : GroupRoleActorFactory.this.groupManager.getUsersInGroup(this.getParameter())) {
                users.add(user);
            }
            return users;
        }

        public boolean contains(ApplicationUser user) {
            return GroupRoleActorFactory.this.groupManager.isUserInGroup(user, this.getParameter());
        }

        public Group getGroup() throws IllegalArgumentException {
            return GroupRoleActorFactory.this.groupManager.getGroupEvenWhenUnknown(this.getParameter());
        }
    }
}

