/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.type.AbstractSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.lucene.util.BytesRef;

public abstract class AbstractProjectsSecurityType
extends AbstractSecurityType {
    @Override
    public boolean isTopLevelProjectPermission() {
        return true;
    }

    @Override
    public Set<BytesRef> getPermissionFieldContents(ApplicationUser searcher, Project project, String parameter) {
        return ImmutableSet.of((Object)SecurityIndexingUtils.generateProjectPermissionFieldContents((Long)project.getId()));
    }

    @Override
    public boolean isTopLevelIssueSecurityPermission() {
        return true;
    }

    @Override
    public Set<BytesRef> getPermissionFieldContents(ApplicationUser searcher, Project project, IssueSecurityLevel securityLevel, String parameter) {
        return this.getPermissionFieldContents(securityLevel);
    }

    protected Set<BytesRef> getPermissionFieldContents(IssueSecurityLevel securityLevel) {
        return ImmutableSet.of((Object)SecurityIndexingUtils.generateIssueLevelPermissionContents((Long)securityLevel.getId()));
    }
}

