/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SingleUser
extends AbstractProjectsSecurityType {
    public static final String DESC = "user";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserManager userManager;

    public SingleUser(JiraAuthenticationContext jiraAuthenticationContext, UserManager userManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userManager = userManager;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.single.user");
    }

    @Override
    public String getArgumentDisplay(String argument) {
        return this.userManager.getUserByKeyEvenWhenUnknown(argument).getDisplayName();
    }

    @Override
    public String getType() {
        return DESC;
    }

    @Override
    public void doValidation(String key, Map<String, String> parameters, JiraServiceContext jiraServiceContext) {
        if (!this.doValidation(key, parameters)) {
            String localisedMessage = this.jiraAuthenticationContext.getI18nHelper().getText("admin.permissions.errors.please.select.user");
            jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
        }
    }

    private boolean doValidation(String key, Map<String, String> parameters) {
        String username = parameters.get(key);
        return username != null && !StringUtils.isBlank((CharSequence)username) && this.userManager.getUserByName(username) != null;
    }

    @Override
    public boolean hasPermission(Project project, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(user, parameter);
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(user, parameter);
    }

    private boolean hasPermission(ApplicationUser user, String parameter) {
        Assertions.notNull((String)DESC, (Object)user);
        Assertions.notNull((String)"parameter", (Object)parameter);
        return parameter.equals(ApplicationUsers.getKeyFor(user));
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String argument) {
        ApplicationUser user = this.userManager.getUserByKey(argument);
        if (user != null) {
            return Collections.singleton(user);
        }
        return Collections.emptySet();
    }
}

