/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.web.dispatcher.JiraWebworkActionDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

class WebworkRequestPredicate
implements Predicate<HttpServletRequest> {
    static final Class<JiraWebworkActionDispatcher> WEBWORK_SERVLET_CLASS = JiraWebworkActionDispatcher.class;
    private final SortedSet<ServletMapping> urlMappingSet;

    private WebworkRequestPredicate(SortedSet<ServletMapping> urlMappingSet) {
        this.urlMappingSet = urlMappingSet;
    }

    static WebworkRequestPredicate create(ServletContext context) {
        Map availableServlets = context.getServletRegistrations();
        TreeSet<ServletMapping> urlMappings = new TreeSet<ServletMapping>(availableServlets.values().stream().flatMap(it -> WebworkRequestPredicate.collectMappings(it).stream()).collect(Collectors.toList()));
        return new WebworkRequestPredicate(urlMappings);
    }

    private static Collection<ServletMapping> collectMappings(ServletRegistration value) {
        String className = value.getClassName();
        return value.getMappings().stream().map(it -> WebworkRequestPredicate.createMapping(className, it)).collect(Collectors.toSet());
    }

    private static ServletMapping createMapping(String className, String inputPattern) {
        String mappingPattern = StringUtils.isEmpty((CharSequence)inputPattern) ? "/" : inputPattern.trim();
        return Stream.of(ServletMapping.Type.PATH, ServletMapping.Type.EXT).filter(type -> type.isUrlMappingCompatible(inputPattern)).findFirst().orElse(ServletMapping.Type.EXACT).toServletMapping(className, mappingPattern);
    }

    @Override
    public boolean test(HttpServletRequest request) {
        return request.getServletPath() != null && this.matchesWebworkDispather(request.getServletPath());
    }

    Set<ServletMapping> getUrlMappings() {
        return Collections.unmodifiableSet(this.urlMappingSet);
    }

    Optional<ServletMapping> resolveMappingFor(String path) {
        return this.urlMappingSet.stream().filter(m -> m.matches(path)).findFirst();
    }

    private boolean matchesWebworkDispather(String path) {
        return this.resolveMappingFor(path).filter(m -> WEBWORK_SERVLET_CLASS.getCanonicalName().equals(m.className)).isPresent();
    }

    static final class ServletMapping
    implements Comparable<ServletMapping> {
        static final Comparator<ServletMapping> priorityComparator = (o1, o2) -> {
            int firstStageCmpRes = Integer.compare(o1.type.ordinal(), o2.type.ordinal());
            int secondStageCmpRes = firstStageCmpRes != 0 ? firstStageCmpRes : Integer.compare(o2.comparableMapping.length(), o1.comparableMapping.length());
            return secondStageCmpRes != 0 ? secondStageCmpRes : o1.comparableMapping.compareTo(o2.comparableMapping);
        };
        final Type type;
        final String className;
        final String comparableMapping;
        final String urlMapping;

        private ServletMapping(Type type, String className, String urlMapping, String comparableMapping) {
            this.type = type;
            this.className = className;
            this.urlMapping = urlMapping;
            this.comparableMapping = comparableMapping;
        }

        boolean matches(String requestPath) {
            return this.type.matches(this.comparableMapping, requestPath);
        }

        @Override
        public int compareTo(ServletMapping o) {
            return priorityComparator.compare(this, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServletMapping that = (ServletMapping)o;
            return this.type == that.type && this.className.equals(that.className) && this.comparableMapping.equals(that.comparableMapping);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.className, this.comparableMapping});
        }

        public String toString() {
            return "ServletMapping{type=" + (Object)((Object)this.type) + ", className='" + this.className + '\'' + ", comparableMapping='" + this.comparableMapping + '\'' + ", urlMapping='" + this.urlMapping + '\'' + '}';
        }

        static enum Type {
            EXACT((m, r) -> r.equals(m), s -> true, s -> s),
            PATH((m, r) -> r.startsWith((String)m), s -> s.endsWith("/*"), s -> s.substring(0, s.length() - 1)),
            EXT((m, r) -> r.endsWith((String)m), s -> s.startsWith("*."), s -> s.substring(2));

            private final BiFunction<String, String, Boolean> matchFunction;
            private final Predicate<String> isUrlMappingCompatible;
            private final Function<String, String> mappingTransformer;

            private Type(BiFunction<String, String, Boolean> matchFunction, Predicate<String> isUrlMappingCompatible, Function<String, String> mappingTransformer) {
                this.matchFunction = matchFunction;
                this.isUrlMappingCompatible = isUrlMappingCompatible;
                this.mappingTransformer = mappingTransformer;
            }

            boolean matches(String mappingPart, String requestPath) {
                return this.matchFunction.apply(mappingPart, requestPath);
            }

            boolean isUrlMappingCompatible(String urlMapping) {
                return this.isUrlMappingCompatible.test(urlMapping);
            }

            ServletMapping toServletMapping(String className, String urlMapping) {
                return new ServletMapping(this, className, urlMapping, this.mappingTransformer.apply(urlMapping));
            }
        }
    }
}

