/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.jira.servermetrics.RequestMetricsCollector;
import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.servermetrics.TimingInformation;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@NotThreadSafe
class NestedRequestsMetricsCollector
implements ServerMetricsDetailCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(NestedRequestsMetricsCollector.class);
    private Optional<RequestMetricsCollector> activeCollector = Optional.empty();
    private final Ticker ticker;
    private int referenceCount;

    public NestedRequestsMetricsCollector(Ticker ticker) {
        this.ticker = ticker;
    }

    public void startCollectionInCurrentThread() {
        if (0 == this.referenceCount) {
            this.activeCollector = Optional.of(RequestMetricsCollector.started(Stopwatch.createUnstarted((Ticker)this.ticker)));
        }
        ++this.referenceCount;
    }

    public void checkpointReached(String checkpointName) {
        this.activeCollector.ifPresent(requestPartitioning -> requestPartitioning.checkpointReached(checkpointName));
    }

    public void checkpointReachedOnce(String checkpointName) {
        this.activeCollector.ifPresent(requestPartitioning -> requestPartitioning.checkpointReachedOnce(checkpointName));
    }

    public void checkpointReachedOverride(String checkpointName) {
        this.activeCollector.ifPresent(requestPartitioning -> requestPartitioning.checkpointReachedOverride(checkpointName));
    }

    public void addTimeSpentInActivity(String activityName, Duration duration) {
        this.activeCollector.ifPresent(requestMetricsCollector -> requestMetricsCollector.addTimeSpentInActivity(activityName, duration));
    }

    public void setTimeSpentInActivity(String activityName, Duration duration) {
        this.activeCollector.ifPresent(requestMetricsCollector -> requestMetricsCollector.setTimeSpentInActivity(activityName, duration));
    }

    public Optional<TimingInformation> finishCollection() {
        --this.referenceCount;
        if (0 == this.referenceCount) {
            Optional<TimingInformation> timingInformation = this.activeCollector.map(RequestMetricsCollector::getCurrentTiming);
            this.activeCollector = Optional.empty();
            return timingInformation;
        }
        if (this.referenceCount < 0) {
            this.referenceCount = 0;
            LOGGER.warn("startCollectionInCurrentThread call count doesn't match finishCollection call count.");
        }
        return Optional.empty();
    }
}

