/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.cluster;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.cluster.OfBizClusterNodeStore;
import com.atlassian.jira.service.AbstractService;
import com.opensymphony.module.propertyset.PropertySet;

public class NodeStateCheckerService
extends AbstractService {
    private final ClusterNodes clusterNodes;
    private final NodeStateManager nodeStateManager;
    private final OfBizClusterNodeStore clusterNodeStore;

    public NodeStateCheckerService(NodeStateManager nodeStateManager, OfBizClusterNodeStore clusterNodeStore, ClusterNodes clusterNodes) {
        this.nodeStateManager = nodeStateManager;
        this.clusterNodeStore = clusterNodeStore;
        this.clusterNodes = clusterNodes;
    }

    public void init(PropertySet properties) throws ObjectConfigurationException {
        super.init(properties);
    }

    public void run() {
        Node.NodeState refreshedNodeState;
        Node node = this.clusterNodes.current();
        if (node.isClustered() && node.getState() == Node.NodeState.ACTIVE && (refreshedNodeState = this.clusterNodeStore.getNode(node.getNodeId()).getState()) == Node.NodeState.PASSIVE) {
            this.passivate();
        }
    }

    private void passivate() {
        try {
            this.nodeStateManager.deactivate();
        }
        catch (NotClusteredException e) {
            throw new IllegalStateException("We got a NotClusteredException trying to passivate in response to a clustered node state change, which is something we only check when we are clustered?!");
        }
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("NODESTATECHECKERSERVICE", "services/com/atlassian/jira/service/services/cluster/nodestatecheckerservice.xml", null);
    }
}

