/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.file;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.util.PathUtils;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class FileService
extends AbstractMessageHandlingService {
    private final Logger log = ((MailLoggingManager)ComponentAccessor.getComponent(MailLoggingManager.class)).getIncomingMailChildLogger("fileservice");
    private static final String KEY_DIRECTORY = "directory";
    private File directory = null;
    public static final String MAIL_DIR = PathUtils.joinPaths((String[])new String[]{"import", "mail"});
    public static final String KEY_SUBDIRECTORY = "subdirectory";

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        String dir = "";
        if (this.hasProperty(KEY_DIRECTORY)) {
            dir = this.getProperty(KEY_DIRECTORY);
        }
        if (StringUtils.isNotBlank((CharSequence)dir)) {
            this.directory = new File(dir);
        } else {
            FilesystemPath mailDir = this.getFileStores().getHomeFilesystemPath().path(new String[]{MAIL_DIR});
            if (this.hasProperty(KEY_SUBDIRECTORY) && StringUtils.isNotBlank((CharSequence)this.getProperty(KEY_SUBDIRECTORY))) {
                try {
                    this.directory = mailDir.path(new String[]{this.getProperty(KEY_SUBDIRECTORY)}).asJavaFile().getCanonicalFile();
                }
                catch (IOException e) {
                    throw new ObjectConfigurationException((Throwable)e);
                }
            } else {
                this.directory = mailDir.asJavaFile();
            }
        }
        if (!this.directory.isDirectory()) {
            this.log.warn((Object)("Directory: " + dir + " setup for FileService is not a directory."));
        } else if (!this.directory.canRead()) {
            this.log.warn((Object)("Directory: " + dir + " setup for FileService does not allow read."));
        } else if (!this.directory.canWrite()) {
            this.log.warn((Object)("Directory: " + dir + " setup for FileService does not allow write."));
        }
    }

    protected List<File> getFilesOnly(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)files.length);
        for (File file : files) {
            if (!file.isFile()) continue;
            result.add(file);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl(MessageHandlerContext context) {
        if (this.directory == null) {
            context.getMonitor().warning("Directory is not set for FileService");
            return;
        }
        if (!this.directory.exists()) {
            context.getMonitor().warning("Directory " + this.directory.getPath() + " does not exist");
            return;
        }
        this.log.debug((Object)("Getting files in directory: " + this.directory));
        List<File> files = this.getFilesOnly(this.directory);
        int filesSize = files.size();
        this.log.debug((Object)this.addHandlerInfo("Found " + filesSize + " message(s)"));
        if (!context.isRealRun()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Found ");
            sb.append(files.size());
            sb.append(" message(s) in the ");
            sb.append(this.directory);
            sb.append(" folder.");
            if (filesSize > 10) {
                sb.append(" Only first 10 messages will be processed in test mode. ");
            }
            context.getMonitor().info(sb.toString());
        }
        context.getMonitor().setNumMessages(filesSize);
        if (filesSize == 0) {
            return;
        }
        MessageHandler handler = this.getHandler();
        if (handler == null) {
            context.getMonitor().error("Handler for this service has not been instantiated. Check handler configuration and corresponding plugin/module state. Exiting run().");
            return;
        }
        for (int i = 0; i < filesSize; ++i) {
            File file = files.get(i);
            if (!context.isRealRun() && i >= 10) {
                this.log.debug((Object)"In dry-run mode only first 10 messages are processed. Skipping the rest");
                break;
            }
            if (!file.isFile() || !file.canRead() || !file.canWrite()) continue;
            this.log.debug((Object)("Trying to parse file: " + file.getAbsolutePath()));
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                MimeMessage message = new MimeMessage(null, (InputStream)fis);
                String msgId = message.getHeader("Message-ID") != null ? message.getHeader("Message-ID")[0] : "null";
                boolean delete = handler.handleMessage((Message)message, context);
                fis.close();
                fis = null;
                if (!delete) continue;
                if (context.isRealRun()) {
                    if (!file.delete()) {
                        context.getMonitor().warning("Unable to delete file '" + file + "'.");
                        continue;
                    }
                    this.log.info((Object)("Deleted file: " + file.getAbsolutePath()));
                    continue;
                }
                context.getMonitor().info("Deleting Message '" + message.getSubject() + "'");
                this.log.debug((Object)("Deleting Message: " + msgId + " (skipped due to dry-run mode)"));
                continue;
            }
            catch (FileNotFoundException e) {
                context.getMonitor().error("File not found when it should be, are two FileServices running?", (Throwable)e);
                continue;
            }
            catch (MessagingException e) {
                context.getMonitor().error("A messaging exception occurred in the FileService.", (Throwable)e);
                continue;
            }
            catch (Exception unexpected) {
                context.getMonitor().error("Unexpected exception in the FileService", (Throwable)unexpected);
                continue;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("FILESERVICE", "services/com/atlassian/jira/service/services/file/fileservice.xml", null);
    }

    FileStores getFileStores() {
        return (FileStores)ComponentAccessor.getComponentOfType(FileStores.class);
    }

    protected Logger getLogger() {
        return this.log;
    }

    protected String addHandlerInfo(String msg) {
        return this.getName() + "[" + this.directory + "]: " + msg;
    }
}

