/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.sharing.SharedEntityColumnDefinition;
import com.atlassian.jira.sharing.index.QueryFactory;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.user.ApplicationUser;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class IsSharedQueryFactory
implements QueryFactory {
    private final FeatureManager featureManager;

    public IsSharedQueryFactory(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Override
    public Query create(SharedEntitySearchParameters searchParameters, ApplicationUser user) {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS)) {
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            query.add((Query)new TermQuery(new Term(SharedEntityColumnDefinition.IS_SHARED.getName(), "true")), BooleanClause.Occur.MUST);
            return query.build();
        }
        return new MatchAllDocsQuery();
    }

    @Override
    public Query create(SharedEntitySearchParameters searchParameters) {
        throw new UnsupportedOperationException();
    }
}

