/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.issue.index.analyzer.WildcardFilter;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.sharing.SharedEntityColumnDefinition;
import com.atlassian.jira.sharing.search.SearchParseException;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class QueryBuilder {
    final BooleanQuery.Builder result = new BooleanQuery.Builder();

    void addParsedQuery(SharedEntityColumn column, String value, BooleanClause.Occur occurance) throws SearchParseException {
        if (!StringUtils.isBlank((String)value)) {
            this.add(QueryBuilder.parseQuery(column, value), occurance);
        }
    }

    void addParsedWildcardQuery(SharedEntityColumn column, String value, BooleanClause.Occur occurance) throws SearchParseException {
        if (!StringUtils.isBlank((String)value)) {
            this.add(QueryBuilder.parseWildcardQuery(column, value), occurance);
        }
    }

    void add(SharedEntityColumn column, String value, BooleanClause.Occur occurance) throws SearchParseException {
        if (!StringUtils.isBlank((String)value)) {
            this.add(new Term(QueryBuilder.getNameFor(column), value), occurance);
        }
    }

    void add(Query query, BooleanClause.Occur occurance) {
        if (query != null) {
            this.result.add(query, occurance);
        }
    }

    void add(Term[] terms, BooleanClause.Occur occurance) {
        for (Term term : terms) {
            this.add(term, occurance);
        }
    }

    void add(Term term, BooleanClause.Occur occurance) {
        if (term != null) {
            this.result.add((Query)new TermQuery(term), occurance);
        }
    }

    void add(QueryBuilder builder, BooleanClause.Occur occurance) {
        if (builder != null && builder.hasClauses()) {
            this.result.add(builder.toQuery(), occurance);
        }
    }

    boolean hasClauses() {
        return !this.result.build().clauses().isEmpty();
    }

    final Query toQuery() {
        if (this.hasClauses()) {
            return this.result.build();
        }
        return new MatchAllDocsQuery();
    }

    QueryBuilder build() {
        return this;
    }

    static Query parseQuery(SharedEntityColumn column, String value) throws SearchParseException {
        if (StringUtils.isBlank((String)value)) {
            return new MatchAllDocsQuery();
        }
        QueryParser parser = new QueryParser(QueryBuilder.getNameFor(column), Analyzers.LOWERCASE);
        parser.setAllowLeadingWildcard(false);
        try {
            return parser.parse(value);
        }
        catch (ParseException e) {
            throw new SearchParseException(e, column);
        }
        catch (RuntimeException re) {
            throw new SearchParseException(re, column);
        }
    }

    static Query parseWildcardQuery(SharedEntityColumn column, String value) throws SearchParseException {
        if (StringUtils.isBlank((String)value)) {
            return new MatchAllDocsQuery();
        }
        QueryParser wildCardParser = new QueryParser(QueryBuilder.getNameFor(column), Analyzers.WILDCARD);
        QueryParser parser = new QueryParser(QueryBuilder.getNameFor(column), Analyzers.STANDARD);
        parser.setAllowLeadingWildcard(false);
        try {
            Query interimQuery = wildCardParser.parse(value);
            return parser.parse(interimQuery.toString());
        }
        catch (ParseException e) {
            throw new SearchParseException(e, column);
        }
    }

    static void checkQueryParameter(SharedEntityColumn column, String value) throws SearchParseException {
        QueryBuilder.parseQuery(column, value);
    }

    public static void validate(SharedEntitySearchParameters searchParameters) throws SearchParseException {
        QueryBuilder.checkQueryParameter(SharedEntityColumn.NAME, searchParameters.getName());
        QueryBuilder.checkQueryParameter(SharedEntityColumn.DESCRIPTION, searchParameters.getDescription());
    }

    private static String getNameFor(SharedEntityColumn column) {
        return SharedEntityColumnDefinition.definitionFor(column).getName();
    }

    static final class Analyzers {
        static final Analyzer STEMMER = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer tokenizer = new StandardTokenizer();
                PorterStemFilter result = new PorterStemFilter((TokenStream)new LowerCaseFilter((TokenStream)new StandardFilter((TokenStream)tokenizer)));
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
            }
        };
        static final Analyzer WILDCARD_STEMMER = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer tokenizer = new StandardTokenizer();
                WildcardFilter result = new WildcardFilter((TokenStream)new PorterStemFilter((TokenStream)new LowerCaseFilter((TokenStream)new StandardFilter((TokenStream)tokenizer))));
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
            }
        };
        static final Analyzer WILDCARD = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer tokenizer = new StandardTokenizer();
                WildcardFilter result = new WildcardFilter((TokenStream)new LowerCaseFilter((TokenStream)new StandardFilter((TokenStream)tokenizer)));
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
            }
        };
        static final Analyzer LOWERCASE = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer tokenizer = new StandardTokenizer();
                LowerCaseFilter result = new LowerCaseFilter((TokenStream)new StandardFilter((TokenStream)tokenizer));
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
            }
        };
        static final Analyzer STANDARD = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer tokenizer = new StandardTokenizer();
                StandardFilter result = new StandardFilter((TokenStream)tokenizer);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
            }
        };

        Analyzers() {
        }
    }
}

