/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.GlobalShareType;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class GlobalShareTypeRenderer
implements ShareTypeRenderer {
    public String renderPermission(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.equals((String)"permission-type", (Object)GlobalShareType.TYPE, (Object)permission.getType());
        return this.getText(authenticationContext, "common.sharing.shared.template.everyone");
    }

    public String getSimpleDescription(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.equals((String)"permission-type", (Object)GlobalShareType.TYPE, (Object)permission.getType());
        return this.getText(authenticationContext, "common.sharing.shared.display.everyone.desc");
    }

    public String getShareTypeEditor(JiraAuthenticationContext authenticationContext) {
        return "";
    }

    public boolean isAddButtonNeeded(JiraAuthenticationContext userCtx) {
        return true;
    }

    public String getShareTypeLabel(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.description.everyone");
    }

    public Map<String, String> getTranslatedTemplates(JiraAuthenticationContext authenticationContext, SharedEntity.TypeDescriptor<? extends SharedEntity> type, ShareTypeRenderer.RenderMode mode) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("share_global_display", StringEscapeUtils.escapeEcmaScript((String)this.getText(authenticationContext, "common.sharing.shared.template.everyone")));
        templates.put("share_global_description", StringEscapeUtils.escapeEcmaScript((String)this.getText(authenticationContext, "common.sharing.shared.template.everyone.desc")));
        templates.put("share_global_warning", StringEscapeUtils.escapeEcmaScript((String)this.getText(authenticationContext, "common.sharing.shared.template.everyone.warning")));
        return Collections.unmodifiableMap(templates);
    }

    private String getText(JiraAuthenticationContext ctx, String key) {
        return ctx.getI18nHelper().getText(key);
    }
}

