/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;

public class ProjectShareTypePermissionChecker
implements ShareTypePermissionChecker {
    private final ProjectManager projectManager;
    private final InternalProjectPermissionHelper projectPermissionHelper;
    private final ProjectRoleManager projectRoleManager;

    public ProjectShareTypePermissionChecker(ProjectManager projectManager, InternalProjectPermissionHelper projectPermissionHelper, ProjectRoleManager projectRoleManager) {
        this.projectManager = projectManager;
        this.projectPermissionHelper = projectPermissionHelper;
        this.projectRoleManager = projectRoleManager;
    }

    public boolean hasPermission(ApplicationUser user, SharePermission permission) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.equals((String)ProjectShareType.TYPE.toString(), (Object)ProjectShareType.TYPE, (Object)permission.getType());
        Assertions.notNull((String)"permission.param1", (Object)permission.getParam1());
        Long projectId = new Long(permission.getParam1());
        Project project = this.projectManager.getProjectObj(projectId);
        if (project == null) {
            return false;
        }
        if (permission.getParam2() == null) {
            return this.projectPermissionHelper.canUserBrowseProject(project, user);
        }
        if (user != null) {
            Long roleId = new Long(permission.getParam2());
            ProjectRole role = this.projectRoleManager.getProjectRole(roleId);
            return role != null && this.projectRoleManager.isUserInProjectRole(user, role, project);
        }
        return false;
    }
}

