/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.DatabaseUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.NodeBuildInfo;
import com.atlassian.jira.cluster.zdu.NodeBuildInfoFactory;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeVersionCheckLauncher {
    private static final Logger log = LoggerFactory.getLogger(ClusterNodeVersionCheckLauncher.class);
    public static final String CHECK_ALLOWANCE_PROPERTY = "jira.clusterMixedVersionCheckTime";
    private static final String PADDING = "    ";
    private static final String TABLE_FORMAT = "    %-30s %15s %20s%n";

    public void start() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        DatabaseUpgradeStateManager clusterStateManager = (DatabaseUpgradeStateManager)ComponentAccessor.getComponent(DatabaseUpgradeStateManager.class);
        if (clusterManager == null || clusterStateManager == null || !clusterManager.isClustered()) {
            return;
        }
        if (clusterStateManager.getDatabaseUpgradeState() == UpgradeState.STABLE) {
            this.verifyVersionOfNodeJoiningStableCluster(clusterManager, JiraSystemProperties.getInstance(), (Clock)ComponentAccessor.getComponent(Clock.class), (NodeBuildInfoFactory)ComponentAccessor.getComponent(NodeBuildInfoFactory.class));
        } else if (clusterStateManager.getDatabaseUpgradeState() == UpgradeState.MIXED || clusterStateManager.getDatabaseUpgradeState() == UpgradeState.READY_TO_RUN_UPGRADE_TASKS) {
            this.verifyThereAreOnlyTwoVersionsInMixedMode(clusterManager, (NodeBuildInfoFactory)ComponentAccessor.getComponent(NodeBuildInfoFactory.class));
        } else if (clusterStateManager.getDatabaseUpgradeState() == UpgradeState.READY_TO_UPGRADE) {
            this.verifyMajorVersion((NodeBuildInfoFactory)ComponentAccessor.getComponent(NodeBuildInfoFactory.class));
        }
    }

    private void verifyMajorVersion(NodeBuildInfoFactory nodeBuildInfoFactory) {
        NodeBuildInfo thisNodeBuildNumber = nodeBuildInfoFactory.currentApplicationInfo();
        ClusterUpgradeStateManager clusterUpgradeStateManager = (ClusterUpgradeStateManager)ComponentAccessor.getComponent(ClusterUpgradeStateManager.class);
        NodeBuildInfo baseClusterBuildNumber = clusterUpgradeStateManager.getClusterBuildInfo();
        String clusterVersion = baseClusterBuildNumber.getVersion();
        String nodeVersion = thisNodeBuildNumber.getVersion();
        if (!this.getMajorVersion(clusterVersion).equals(this.getMajorVersion(nodeVersion))) {
            throw new IllegalStateException(String.format("Your node with Jira version %s will not start up with version %s because Jira does not support zero downtime upgrades between major releases. See https://docs.atlassian.com/jira/jadm-docs-080/Upgrading+Jira+applications.", nodeVersion, clusterVersion));
        }
    }

    private Integer getMajorVersion(String version) {
        return Integer.parseInt(version.split("\\.")[0]);
    }

    private void verifyThereAreOnlyTwoVersionsInMixedMode(ClusterManager clusterManager, NodeBuildInfoFactory nodeBuildInfoFactory) {
        NodeBuildInfo thisNodeBuildNumber = nodeBuildInfoFactory.currentApplicationInfo();
        ClusterUpgradeStateManager clusterUpgradeStateManager = (ClusterUpgradeStateManager)ComponentAccessor.getComponent(ClusterUpgradeStateManager.class);
        NodeBuildInfo baseClusterBuildNumber = clusterUpgradeStateManager.getClusterBuildInfo();
        if (baseClusterBuildNumber.getBuildNumber() > thisNodeBuildNumber.getBuildNumber()) {
            throw new IllegalStateException("Refusing to start up this node. Version of this node is older than version of cluster.");
        }
        List<Node> nodesInCluster = this.findOtherNodesInCluster(clusterManager);
        List nodeBuildNumbers = nodesInCluster.stream().map(Node::getNodeBuildNumber).collect(Collectors.toList());
        if (!nodeBuildNumbers.isEmpty() && !nodeBuildNumbers.contains(thisNodeBuildNumber.getBuildNumber()) && baseClusterBuildNumber.getBuildNumber() != thisNodeBuildNumber.getBuildNumber()) {
            log.warn(this.createCurrentNodeTable(nodesInCluster));
            throw new IllegalStateException("Refusing to start up this node. Version does not match either base version of cluster or one cluster is upgraded to");
        }
    }

    private void verifyVersionOfNodeJoiningStableCluster(ClusterManager clusterManager, JiraProperties systemProperties, Clock clock, NodeBuildInfoFactory nodeBuildInfoFactory) {
        NodeBuildInfo thisNodeBuildNumber = nodeBuildInfoFactory.currentApplicationInfo();
        try {
            List<Node> differentBuildNumberNodes;
            Long checkAllowancePropertyValue = systemProperties.getLong(CHECK_ALLOWANCE_PROPERTY, Long.valueOf(300L));
            Duration checkTime = Duration.of(checkAllowancePropertyValue, ChronoUnit.SECONDS);
            Instant checkStart = Instant.now(clock);
            Instant checkLimit = checkStart.plus(checkTime);
            Instant lastLog = Instant.MIN;
            do {
                Instant now = Instant.now(clock);
                List<Node> otherNodes = this.findOtherNodesInCluster(clusterManager);
                differentBuildNumberNodes = otherNodes.stream().filter(node -> !nodeBuildInfoFactory.create((Node)node).equals(thisNodeBuildNumber)).collect(Collectors.toList());
                if (differentBuildNumberNodes.isEmpty()) continue;
                if (lastLog.isBefore(Instant.now(clock).minus(Duration.of(5L, ChronoUnit.SECONDS)))) {
                    this.logWaitingForNodesToDisappear(now, nodeBuildInfoFactory, thisNodeBuildNumber, checkLimit, differentBuildNumberNodes);
                    lastLog = now;
                }
                Thread.sleep(1000L);
            } while (!differentBuildNumberNodes.isEmpty() && Instant.now(clock).isBefore(checkLimit));
            if (!differentBuildNumberNodes.isEmpty()) {
                NodeBuildInfo nodeBuildInfo = nodeBuildInfoFactory.create((Node)differentBuildNumberNodes.get(0));
                throw new RuntimeException("Refusing to start up this node. " + this.createOffendingNodeString(thisNodeBuildNumber, differentBuildNumberNodes, nodeBuildInfo) + this.createOffendingNodeTable(differentBuildNumberNodes));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while checking node versions.", e);
        }
    }

    private List<Node> findOtherNodesInCluster(ClusterManager clusterManager) {
        String thisNodeId = clusterManager.getNodeId();
        ArrayList<Node> otherNodes = new ArrayList<Node>();
        clusterManager.refreshLiveNodes();
        for (Node liveNode : clusterManager.findLiveNodes()) {
            if (thisNodeId.equals(liveNode.getNodeId())) continue;
            otherNodes.add(liveNode);
        }
        return otherNodes;
    }

    private void logWaitingForNodesToDisappear(Instant now, NodeBuildInfoFactory nodeBuildInfoFactory, NodeBuildInfo thisNodeBuildNumber, Instant checkLimit, List<Node> differentBuildNumberNodes) {
        NodeBuildInfo nodeBuildInfo = nodeBuildInfoFactory.create(differentBuildNumberNodes.get(0));
        log.warn(this.createOffendingNodeString(thisNodeBuildNumber, differentBuildNumberNodes, nodeBuildInfo) + ", delaying start-up for up to " + Duration.between(now, checkLimit).getSeconds() + " seconds.");
    }

    private String createCurrentNodeTable(List<Node> buildNumbeNodes) {
        return String.format("%n%n%sThe following nodes are currently in cluster: %n%s%n%n%s%n%n%sit means there are already two different build numbers in cluster %n%sthird build number is not allowed. %n%n", PADDING, PADDING, this.buildNodesTable(buildNumbeNodes), PADDING, PADDING);
    }

    private String createOffendingNodeTable(List<Node> differentBuildNumberNodes) {
        return String.format("%n%n%sThe following nodes run a different version of JIRA and are%n%spreventing startup of this node:%n%n%s%n%n%sThese nodes must be stopped or removed from the cluster before %n%sthis node will start.%n%n", PADDING, PADDING, this.buildNodesTable(differentBuildNumberNodes), PADDING, PADDING);
    }

    private String buildNodesTable(List<Node> nodes) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format(TABLE_FORMAT, "Node ID", "Build Number", "Version")).append(PADDING).append(StringUtils.repeat((char)'-', (int)67)).append(String.format("%n", new Object[0]));
        nodes.forEach(node -> buf.append(String.format(TABLE_FORMAT, node.getNodeId(), node.getNodeBuildNumber(), node.getNodeVersion())));
        return buf.toString();
    }

    private String createOffendingNodeString(NodeBuildInfo thisNodeBuildNumber, List<Node> differentBuildNumberNodes, NodeBuildInfo nodeBuildInfo) {
        return "Node with different build number (\"" + differentBuildNumberNodes.get(0).getNodeId() + "\" with version " + nodeBuildInfo.getVersion() + "/" + nodeBuildInfo.getBuildNumber() + ") from this node (" + thisNodeBuildNumber.getVersion() + "/" + thisNodeBuildNumber.getBuildNumber() + ") detected";
    }
}

