/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.index.ha.DefaultIndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRecoveryLauncher {
    private static final String DR_PROPERTY_KEY = "disaster.recovery";
    private static final Logger LOG = LoggerFactory.getLogger(IndexRecoveryLauncher.class);
    private final Supplier<Instant> currentTime;

    IndexRecoveryLauncher() {
        this(Instant::now);
    }

    @VisibleForTesting
    IndexRecoveryLauncher(Supplier<Instant> currentTime) {
        this.currentTime = currentTime;
    }

    private boolean shouldRunIndexRecovery() {
        return "true".equals(ComponentAccessor.getApplicationProperties().getString("jira.setup")) && !((ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class)).getOption(DR_PROPERTY_KEY);
    }

    private boolean isClustered() {
        return ((ClusterManager)ComponentAccessor.getComponent(ClusterManager.class)).isClustered();
    }

    public void start() {
        this.runIndexRecoveryJob();
    }

    void startIndexRecovery() {
        if (this.shouldRunIndexRecovery()) {
            if (this.isClustered()) {
                this.handleIndexRecoveryInClusteredMode();
            } else {
                this.handleIndexRecoveryInServerMode();
            }
        } else {
            LOG.info("Not running index recovery in setup or disaster recovery mode");
        }
    }

    private void handleIndexRecoveryInClusteredMode() {
    }

    private void handleIndexRecoveryInServerMode() {
        LOG.info("Running start-index-recovery");
        IndexRecoveryManager recoveryManager = (IndexRecoveryManager)ComponentAccessor.getComponent(IndexRecoveryManager.class);
        try {
            DateUtils.DateRange dateRange = recoveryManager.getDurationToCatchUpUsingVersions();
            if (dateRange == null) {
                return;
            }
            long difference = Math.abs(dateRange.endDate.getTime() - dateRange.startDate.getTime());
            if (difference > TimeUnit.DAYS.toMillis(2L)) {
                LOG.error("[INDEX-FIXER] Issue index is out of date with the database (issue_version) by more than 48 hours. Automatic recovery will not be attempted");
                return;
            }
            Instant rangeStart = dateRange.startDate.toInstant();
            Duration paddedDuration = DefaultIndexRecoveryManager.padDurationBetween(rangeStart, this.currentTime);
            LOG.info("[INDEX-FIXER] Ensuring index correctness for operations in the last {}. (Note: it's an intentionally wider range)", (Object)DefaultIndexRecoveryManager.readableDuration(paddedDuration));
            recoveryManager.reindexWithVersionCheckEntitiesUpdatedInTheLast(paddedDuration, (taskProgress, currentSubTask, message) -> LOG.info("[INDEX-FIXER] Progress={}%, task={}, message={}", new Object[]{taskProgress, currentSubTask, message}));
        }
        catch (IndexException | SearchException | RuntimeException e) {
            LOG.error("Automatic index recovery failed", e);
        }
        LOG.info("Finished start-index-recovery");
    }

    private void runIndexRecoveryJob() {
        JobRunnerKey runnerKey = JobRunnerKey.of((String)"com.atlassian.jira.DefaultJiraLauncher.IndexRecovery");
        SchedulerService schedulerService = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
        schedulerService.registerJobRunner(runnerKey, r -> {
            this.startIndexRecovery();
            return JobRunnerResponse.success();
        });
        try {
            schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)runnerKey).withSchedule(Schedule.runOnce((Date)new Date())));
        }
        catch (SchedulerServiceException e) {
            LOG.error("Index recovery not scheduled", (Throwable)e);
        }
    }
}

