/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.task.ScalingTaskProgessSink;
import com.atlassian.jira.task.StepTaskProgressSink;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class StatefulTaskProgressSink
implements TaskProgressSink {
    private final TaskProgressSink delegateSink;
    private long currentProgress;
    private final long maxProgress;
    private final long minProgress;

    public StatefulTaskProgressSink(long minProgress, long maxProgress, long currentProgress, TaskProgressSink delegateSink) {
        if (minProgress > maxProgress) {
            throw new IllegalArgumentException("minProgress must be < maxProgress.");
        }
        Assertions.notNull((String)"delegateSink", (Object)delegateSink);
        this.minProgress = minProgress;
        this.maxProgress = maxProgress;
        this.delegateSink = delegateSink;
        this.currentProgress = StatefulTaskProgressSink.clamp(minProgress, maxProgress, currentProgress);
    }

    public StatefulTaskProgressSink(long minProgress, long maxProgress, TaskProgressSink delegateSink) {
        this(minProgress, maxProgress, minProgress, delegateSink);
    }

    public void makeProgress(long taskProgress, String currentSubTask, String message) {
        this.setProgress(taskProgress);
        this.delegateSink.makeProgress(this.getProgress(), currentSubTask, message);
    }

    public void makeProgressIncrement(long increment, String currentSubTask, String message) {
        this.makeProgress(this.getProgress() + increment, currentSubTask, message);
    }

    public void makeProgress(String currentSubTask, String message) {
        this.delegateSink.makeProgress(this.getProgress(), currentSubTask, message);
    }

    public StepTaskProgressSink createStepSinkView(long startProgress, long length, int numberOfActions) {
        if (length < 0L) {
            throw new IllegalArgumentException("length must be >= 0.");
        }
        if (numberOfActions < 0) {
            throw new IllegalArgumentException("numberOfActions must be >= 0.");
        }
        startProgress = this.clamp(startProgress);
        long endProgress = this.clamp(startProgress + length);
        return new StepTaskProgressSink(startProgress, endProgress, numberOfActions, this);
    }

    public StepTaskProgressSink createStepSinkView(long length, int numberOfActions) {
        return this.createStepSinkView(this.getProgress(), length, numberOfActions);
    }

    public static Collection<StatefulTaskProgressSink> createPercentageSinksForRange(long startRange, long endRange, int numberOfDivisions, TaskProgressSink sink) {
        Assertions.notNull((String)"sink", (Object)sink);
        Assertions.not((String)"startRange must be <= endRange.", (startRange > endRange ? 1 : 0) != 0);
        Assertions.not((String)"divisions must be >= 0", (numberOfDivisions < 0 ? 1 : 0) != 0);
        if (numberOfDivisions > 0) {
            long currentStart = startRange;
            double increment = (double)(endRange - startRange) / (double)numberOfDivisions;
            ArrayList list = Lists.newArrayListWithCapacity((int)numberOfDivisions);
            for (int i = 0; i < numberOfDivisions - 1; ++i) {
                long nextStart = Math.min(Math.round((double)currentStart + increment), endRange);
                list.add(new StatefulTaskProgressSink(0L, 100L, new ScalingTaskProgessSink(currentStart, nextStart, 0L, 100L, sink)));
                currentStart = nextStart;
            }
            list.add(new StatefulTaskProgressSink(0L, 100L, new ScalingTaskProgessSink(currentStart, endRange, 0L, 100L, sink)));
            return list;
        }
        return Collections.emptyList();
    }

    public long getProgress() {
        return this.currentProgress;
    }

    public void setProgress(long currentProgress) {
        this.currentProgress = this.clamp(currentProgress);
    }

    public long getMaxProgress() {
        return this.maxProgress;
    }

    public long getMinProgress() {
        return this.minProgress;
    }

    private long clamp(long value) {
        return StatefulTaskProgressSink.clamp(this.minProgress, this.maxProgress, value);
    }

    private static long clamp(long min, long max, long value) {
        if (min > max) {
            long tmp = min;
            min = max;
            max = tmp;
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }
}

