/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.log4j.Logger;

public class TimeBasedLogSink
extends StatefulTaskProgressSink {
    private long lastEventSeen = 0L;
    private final Logger log;
    private final String description;
    private final long maxTimeBetweenEvents;

    public TimeBasedLogSink(Logger log, String description, long maxTimeBetweenEvents, TaskProgressSink delegateSink) {
        super(0L, 100L, delegateSink);
        Assertions.notNull((String)"log", (Object)log);
        Assertions.notNull((String)"description", (Object)description);
        Assertions.not((String)"maxTimeBetweenEvents < 0", (maxTimeBetweenEvents < 0L ? 1 : 0) != 0);
        this.log = log;
        this.maxTimeBetweenEvents = maxTimeBetweenEvents;
        this.description = description;
    }

    @Override
    public void makeProgress(long taskProgress, String currentSubTask, String message) {
        boolean logMsg = false;
        long now = System.currentTimeMillis();
        if (this.getProgress() != taskProgress) {
            logMsg = true;
        } else if (now - this.lastEventSeen >= this.maxTimeBetweenEvents) {
            logMsg = true;
        }
        if (logMsg) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.description);
            sb.append(" [").append(taskProgress).append("%] ");
            if (currentSubTask != null) {
                sb.append(currentSubTask);
                sb.append(" ");
            }
            if (message != null) {
                sb.append(message);
            }
            this.log.info((Object)sb.toString());
        }
        this.lastEventSeen = now;
        super.makeProgress(taskProgress, currentSubTask, message);
    }
}

