/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.jira.mail.EmailType;
import com.atlassian.jira.template.TemplatesValidationConfig;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Immutable
public class DefaultEmailType
implements EmailType {
    private static final String BATCHED_EMAIL_TEMPLATES = "email-batch";
    private final long id;
    private final String eventName;
    private final String templateName;
    private final boolean html;
    private final boolean text;
    private final boolean batchedNotification;
    private final boolean active;

    public DefaultEmailType(long id, String eventName, String templateName, boolean html, boolean text, boolean batchedNotification, boolean active) {
        this.id = id;
        this.eventName = Objects.requireNonNull(eventName);
        this.templateName = Objects.requireNonNull(templateName);
        this.html = html;
        this.text = text;
        this.batchedNotification = batchedNotification;
        this.active = active;
    }

    public static Optional<DefaultEmailType> of(TemplatesValidationConfig.TemplateInfo templateInfo, boolean mailBatchingEnabled) {
        if (!templateInfo.isUseForTestEmail()) {
            return Optional.empty();
        }
        boolean batchedNotification = templateInfo.getFolder().startsWith(BATCHED_EMAIL_TEMPLATES);
        boolean active = mailBatchingEnabled ? templateInfo.isUsedWhenBatchingEnabled() : !batchedNotification;
        return Optional.of(new DefaultEmailType(templateInfo.getId(), templateInfo.getName(), templateInfo.getTemplate(), templateInfo.isHtml(), templateInfo.isText(), batchedNotification, active));
    }

    public long getId() {
        return this.id;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean isHtml() {
        return this.html;
    }

    public boolean isText() {
        return this.text;
    }

    public boolean isBatchedNotification() {
        return this.batchedNotification;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEmailType that = (DefaultEmailType)o;
        return this.id == that.id && this.html == that.html && this.text == that.text && this.batchedNotification == that.batchedNotification && this.active == that.active && Objects.equals(this.eventName, that.eventName) && Objects.equals(this.templateName, that.templateName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.eventName, this.templateName, this.html, this.text, this.batchedNotification, this.active);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("eventName", (Object)this.eventName).append("templateName", (Object)this.templateName).append("html", this.html).append("text", this.text).append("batchedNotification", this.batchedNotification).append("active", this.active).toString();
    }
}

