/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.template.JiraHomeTemplateContentLoader;
import com.atlassian.jira.util.InjectableComponent;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class JiraHomeTemplateContentLoaderImpl
implements JiraHomeTemplateContentLoader {
    private static final Logger log = LoggerFactory.getLogger(JiraHomeTemplateContentLoaderImpl.class);
    private final ApplicationProperties applicationProperties;
    private final String dataDir;

    public JiraHomeTemplateContentLoaderImpl(ApplicationProperties applicationProperties, FileStores fileStores) {
        this.applicationProperties = applicationProperties;
        this.dataDir = fileStores.getHomeFilesystemPath().path(new String[]{"data"}).asJavaFile().getPath() + "/";
    }

    public Optional<String> getTemplateContent(String templateFileName) {
        return this.loadFileContent(this.dataDir + templateFileName);
    }

    public Optional<String> getCssContent(String cssFileName) {
        return this.loadFileContent(this.dataDir + cssFileName);
    }

    private Optional<String> loadFileContent(String filePath) {
        File file = this.newFile(filePath);
        if (!file.exists()) {
            log.info("File not found: {}", (Object)filePath);
            return Optional.empty();
        }
        try {
            return Optional.of(this.readFile(file));
        }
        catch (IOException e) {
            log.error(String.format("Error while reading file: %s", filePath), (Throwable)e);
            return Optional.empty();
        }
    }

    @VisibleForTesting
    protected File newFile(String filePath) {
        return new File(filePath);
    }

    @VisibleForTesting
    protected String readFile(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)this.applicationProperties.getEncoding());
    }
}

