/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.template.CustomTemplatesFeatureAvailabilityCheck;
import com.atlassian.jira.template.DelegatingJiraVelocityManager;
import com.atlassian.jira.template.velocity.CachingVelocityEngineFactory;
import com.atlassian.jira.template.velocity.EmailVelocityEngineFactory;
import com.atlassian.velocity.JiraVelocityManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDelegatingJiraVelocityManager
implements DelegatingJiraVelocityManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultDelegatingJiraVelocityManager.class);
    private static final String ERROR_MESSAGE = "Error while using JiraHomeVelocityManager. Will fallback to classpath JiraVelocityManager";
    private final JiraVelocityManager jiraVelocityManager;
    private final JiraVelocityManager emailVelocityManager;
    private final CustomTemplatesFeatureAvailabilityCheck customTemplatesFeatureAvailabilityCheck;

    public DefaultDelegatingJiraVelocityManager(JiraVelocityManager jiraVelocityManager, JiraHome jiraHome, DateTimeFormatter dateTimeFormatter, CustomTemplatesFeatureAvailabilityCheck customTemplatesFeatureAvailabilityCheck) {
        this(jiraVelocityManager, new JiraVelocityManager(dateTimeFormatter, new CachingVelocityEngineFactory(new EmailVelocityEngineFactory(jiraHome))), customTemplatesFeatureAvailabilityCheck);
    }

    @VisibleForTesting
    DefaultDelegatingJiraVelocityManager(JiraVelocityManager jiraVelocityManager, JiraVelocityManager emailVelocityManager, CustomTemplatesFeatureAvailabilityCheck customTemplatesFeatureAvailabilityCheck) {
        this.jiraVelocityManager = jiraVelocityManager;
        this.emailVelocityManager = emailVelocityManager;
        this.customTemplatesFeatureAvailabilityCheck = customTemplatesFeatureAvailabilityCheck;
    }

    public String getBody(String templateDirectory, String template, Map<String, Object> contextParameters) {
        return this.delegate(() -> this.emailVelocityManager.getBody(templateDirectory, template, contextParameters), () -> this.jiraVelocityManager.getBody(templateDirectory, template, contextParameters));
    }

    public String getBody(String templateDirectory, String template, String baseurl, Map<String, Object> contextParameters) {
        return this.delegate(() -> this.emailVelocityManager.getBody(templateDirectory, template, baseurl, contextParameters), () -> this.jiraVelocityManager.getBody(templateDirectory, template, baseurl, contextParameters));
    }

    public String getEncodedBody(String templateDirectory, String template, String encoding, Map<String, Object> contextParameters) {
        return this.delegate(() -> this.emailVelocityManager.getEncodedBody(templateDirectory, template, encoding, contextParameters), () -> this.jiraVelocityManager.getEncodedBody(templateDirectory, template, encoding, contextParameters));
    }

    public String getEncodedBody(String templateDirectory, String template, String baseurl, String encoding, Map<String, Object> contextParameters) {
        return this.delegate(() -> this.emailVelocityManager.getEncodedBody(templateDirectory, template, baseurl, encoding, contextParameters), () -> this.jiraVelocityManager.getEncodedBody(templateDirectory, template, baseurl, encoding, contextParameters));
    }

    public String getEncodedBody(String templateDirectory, String template, String baseurl, String encoding, Context context) {
        return this.delegate(() -> this.emailVelocityManager.getEncodedBody(templateDirectory, template, baseurl, encoding, context), () -> this.jiraVelocityManager.getEncodedBody(templateDirectory, template, baseurl, encoding, context));
    }

    public String getEncodedBodyForContent(String content, String baseurl, Map<String, Object> contextParameters) {
        return this.delegate(() -> this.emailVelocityManager.getEncodedBodyForContent(content, baseurl, contextParameters), () -> this.jiraVelocityManager.getEncodedBodyForContent(content, baseurl, contextParameters));
    }

    public DateFormat getDateFormat() {
        return this.delegate(this.emailVelocityManager::getDateFormat, this.jiraVelocityManager::getDateFormat);
    }

    public void writeEncodedBodyForContent(Writer writer, String contentFragment, Context context) throws IOException {
        if (this.customTemplatesFeatureAvailabilityCheck.isFeatureFullyAvailable()) {
            try {
                this.emailVelocityManager.writeEncodedBodyForContent(writer, contentFragment, context);
                return;
            }
            catch (Exception e) {
                log.error(ERROR_MESSAGE, (Throwable)e);
            }
        }
        this.jiraVelocityManager.writeEncodedBodyForContent(writer, contentFragment, context);
    }

    public void writeEncodedBody(Writer writer, String templateDirectory, String template, String encoding, Context context) throws IOException {
        if (this.customTemplatesFeatureAvailabilityCheck.isFeatureFullyAvailable() && this.emailVelocityManager.isTemplateAvailable(templateDirectory, template, encoding)) {
            try {
                this.emailVelocityManager.writeEncodedBody(writer, templateDirectory, template, encoding, context);
                return;
            }
            catch (Exception e) {
                log.error(ERROR_MESSAGE, (Throwable)e);
            }
        }
        this.jiraVelocityManager.writeEncodedBody(writer, templateDirectory, template, encoding, context);
    }

    private <T> T delegate(Supplier<T> jiraHomeManagerMethod, Supplier<T> classpathManagerMethod) {
        if (this.customTemplatesFeatureAvailabilityCheck.isFeatureFullyAvailable()) {
            try {
                return jiraHomeManagerMethod.get();
            }
            catch (Exception e) {
                log.error(ERROR_MESSAGE, (Throwable)e);
            }
        }
        return classpathManagerMethod.get();
    }
}

