/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tenancy;

import com.atlassian.jira.tenancy.JiraTenantImpl;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.TenantContext;
import com.atlassian.tenancy.api.TenantUnavailableException;
import com.atlassian.tenancy.api.UnexpectedTenantChangeException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraTenantAccessor
implements TenantAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraTenantAccessor.class);
    private static final Tenant SYSTEM_TENANT = new JiraTenantImpl("system");
    private final TenantContext tenantContext;

    public DefaultJiraTenantAccessor(TenantContext tenantContext) {
        this.tenantContext = tenantContext;
    }

    public Iterable<Tenant> getAvailableTenants() {
        return Collections.singleton(SYSTEM_TENANT);
    }

    public <T> T asTenant(Tenant tenant, Callable<T> call) throws TenantUnavailableException, InvocationTargetException {
        Tenant currentTenant = this.tenantContext.getCurrentTenant();
        if (currentTenant == null) {
            log.warn("You are not associated with a tenant, so cannot call tenant specific code");
            throw new TenantUnavailableException();
        }
        if (tenant != currentTenant) {
            log.warn("You cannot invoke a runnable in another tenant's context");
            throw new UnexpectedTenantChangeException();
        }
        try {
            return call.call();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }
}

