/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.timezone;

import com.atlassian.jira.timezone.GMTOffsetConverter;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.util.I18nHelper;
import java.util.TimeZone;

public class TimeZoneInfoImpl
implements TimeZoneInfo {
    private final String timeZoneId;
    private final String displayName;
    private final TimeZone timeZone;
    private final I18nHelper i18nHelper;
    private final String regionKey;

    public TimeZoneInfoImpl(String timeZoneId, String displayName, TimeZone timeZone, I18nHelper i18nHelper, String regionKey) {
        this.timeZoneId = timeZoneId;
        this.displayName = displayName;
        this.timeZone = timeZone;
        this.i18nHelper = i18nHelper;
        this.regionKey = regionKey;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGMTOffset() {
        return GMTOffsetConverter.GMT_OFFSET_CONVERTER.apply(this.timeZone);
    }

    public String getCity() {
        String zoneLabel = this.timeZoneId;
        if ("System".equals(zoneLabel) || "JIRA".equals(zoneLabel)) {
            zoneLabel = this.timeZone.getID();
        }
        zoneLabel = zoneLabel.replaceAll("/", ".");
        return this.i18nHelper.getText("timezone.zone." + zoneLabel.toLowerCase());
    }

    public String getRegionKey() {
        return this.regionKey;
    }

    public TimeZone toTimeZone() {
        return this.timeZone;
    }

    public int compareTo(TimeZoneInfo timeZoneInfo) {
        int rawOffset = timeZoneInfo.toTimeZone().getRawOffset();
        if (this.timeZone.getRawOffset() < rawOffset) {
            return -1;
        }
        if (this.timeZone.getRawOffset() > rawOffset) {
            return 1;
        }
        return this.getCity().compareTo(timeZoneInfo.getCity());
    }

    public String toString() {
        return "TimeZoneInfoImpl{" + this.timeZoneId + '}';
    }
}

