/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.upgrade.BuildVersionImpl;
import com.atlassian.jira.upgrade.BuildVersionRegistry;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.Nonnull;

@InjectableComponent
public class DefaultBuildVersionRegistry
implements BuildVersionRegistry {
    private static final String BUILD_VERSIONS_PROPERTIES = "build-versions.properties";
    private final Map<Integer, String> buildVersionProperties;
    private final BuildUtilsInfo buildUtilsInfo;

    public DefaultBuildVersionRegistry(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.buildVersionProperties = new TreeMap<Integer, String>();
        this.loadBuildVersions();
    }

    @Override
    public BuildVersionRegistry.BuildVersion getVersionForBuildNumber(int buildNumber) {
        if (this.buildVersionProperties.containsKey(buildNumber)) {
            String version = this.buildVersionProperties.get(buildNumber);
            return new BuildVersionImpl(buildNumber, version);
        }
        for (Integer buildNumberKey : this.buildVersionProperties.keySet()) {
            if (buildNumberKey < buildNumber) continue;
            String version = this.buildVersionProperties.get(buildNumberKey);
            return new BuildVersionImpl(buildNumberKey, version);
        }
        return new BuildVersionImpl(this.buildUtilsInfo.getApplicationBuildNumber(), this.buildUtilsInfo.getVersion());
    }

    @Override
    public BuildVersionRegistry.BuildVersion getVersionForBuildNumber(String targetBuildNumber) {
        Integer targetBuildInt;
        Assertions.notBlank((String)"targetBuildNumber", (String)targetBuildNumber);
        try {
            targetBuildInt = Integer.valueOf(targetBuildNumber);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
        return this.getVersionForBuildNumber(targetBuildInt);
    }

    @Override
    public BuildVersionRegistry.BuildVersion getBuildNumberForVersion(@Nonnull String targetVersion) {
        for (Map.Entry<Integer, String> entry : this.buildVersionProperties.entrySet()) {
            if (!entry.getValue().equals(targetVersion)) continue;
            return new BuildVersionImpl(entry.getKey(), entry.getValue());
        }
        return new BuildVersionImpl(Integer.MAX_VALUE, targetVersion);
    }

    private void loadBuildVersions() {
        Properties props = new Properties();
        InputStream in = ClassLoaderUtils.getResourceAsStream((String)BUILD_VERSIONS_PROPERTIES, DefaultBuildVersionRegistry.class);
        try {
            props.load(in);
            in.close();
            for (Object o : props.keySet()) {
                Integer buildNumber;
                String key = (String)o;
                try {
                    buildNumber = Integer.valueOf(key);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid build number '" + key + "' in build versions properties file '" + BUILD_VERSIONS_PROPERTIES + "'.", e);
                }
                this.buildVersionProperties.put(buildNumber, props.getProperty(key));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load build versions properties from 'build-versions.properties'.", e);
        }
    }
}

