/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.extras.api.LicenseException;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.license.MultiLicenseStore;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeService;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeLauncher {
    private static final Logger log = LoggerFactory.getLogger(UpgradeLauncher.class);
    private static final String NO_UPGRADE_MESSAGE = "No upgrade is being performed due to detected inconsistencies.";
    private static final String NEWLINE = JiraSystemProperties.getInstance().getProperty("line.separator");
    private final JohnsonEventContainer johnsonEventContainer;
    private final Supplier<ApplicationProperties> applicationPropertiesSupplier;
    private final Supplier<Boolean> isStartupOkSupplier;
    private final Supplier<JiraLicenseService> jiraLicenseServiceSupplier;
    private final Supplier<LicenseJohnsonEventRaiser> licenseJohnsonEventRaiserSupplier;
    private final Supplier<MultiLicenseStore> multiLicenseStoreSupplier;
    private final Supplier<UpgradeService> upgradeServiceSupplier;

    public UpgradeLauncher(JohnsonProvider johnsonProvider) {
        this(johnsonProvider.getContainer(), ComponentAccessor.supplierOf(ApplicationProperties.class), ComponentAccessor.supplierOf(JiraLicenseService.class), ComponentAccessor.supplierOf(LicenseJohnsonEventRaiser.class), ComponentAccessor.supplierOf(MultiLicenseStore.class), ComponentAccessor.supplierOf(UpgradeService.class), JohnsonProvider::isStartupOk);
    }

    @VisibleForTesting
    UpgradeLauncher(JohnsonEventContainer johnsonEventContainer, Supplier<ApplicationProperties> applicationPropertiesSupplier, Supplier<JiraLicenseService> jiraLicenseServiceSupplier, Supplier<LicenseJohnsonEventRaiser> licenseJohnsonEventRaiserSupplier, Supplier<MultiLicenseStore> multiLicenseStoreSupplier, Supplier<UpgradeService> upgradeServiceSupplier, Supplier<Boolean> isStartupOkSupplier) {
        this.applicationPropertiesSupplier = Objects.requireNonNull(applicationPropertiesSupplier);
        this.jiraLicenseServiceSupplier = Objects.requireNonNull(jiraLicenseServiceSupplier);
        this.johnsonEventContainer = Objects.requireNonNull(johnsonEventContainer);
        this.licenseJohnsonEventRaiserSupplier = Objects.requireNonNull(licenseJohnsonEventRaiserSupplier);
        this.multiLicenseStoreSupplier = Objects.requireNonNull(multiLicenseStoreSupplier);
        this.upgradeServiceSupplier = Objects.requireNonNull(upgradeServiceSupplier);
        this.isStartupOkSupplier = Objects.requireNonNull(isStartupOkSupplier);
    }

    public void start() {
        if (this.jiraIsSetUp()) {
            this.ensureLicenseNotCorrupted();
            if (this.isStartupOkSupplier.get().booleanValue()) {
                if (this.licenseIsValid()) {
                    this.upgradeIfNeeded();
                } else {
                    log.error(this.constructErrorMessage());
                }
            } else {
                log.error("Skipping, JIRA is locked.");
            }
        }
    }

    private boolean jiraIsSetUp() {
        return "true".equals(this.applicationPropertiesSupplier.get().getString("jira.setup"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeIfNeeded() {
        Event upgradingEvent = new Event(JohnsonEventType.UPGRADE.eventType(), "JIRA is currently being upgraded", EventLevels.warning());
        upgradingEvent.addAttribute((Object)"dismissible", (Object)true);
        this.johnsonEventContainer.addEvent(upgradingEvent);
        UpgradeService upgradeService = this.upgradeServiceSupplier.get();
        try {
            UpgradeResult result = upgradeService.runUpgrades();
            this.addEventsForErrors(result);
        }
        catch (Exception upgradeException) {
            log.error("An error occurred whilst trying to upgrade JIRA.", (Throwable)upgradeException);
            Event errorEvent = UpgradeLauncher.asUpgradeError(upgradeException.getMessage());
            this.johnsonEventContainer.addEvent(errorEvent);
        }
        finally {
            this.johnsonEventContainer.removeEvent(upgradingEvent);
        }
    }

    private void ensureLicenseNotCorrupted() {
        JiraLicenseService jiraLicenseService = this.jiraLicenseServiceSupplier.get();
        try {
            jiraLicenseService.getLicenses();
        }
        catch (LicenseException e) {
            log.error("This instance contains one or more corrupt licenses. All licenses will be removed and licenses will need to be re-entered.");
            this.multiLicenseStoreSupplier.get().clear();
        }
    }

    private boolean licenseIsValid() {
        JiraLicenseService jiraLicenseService = this.jiraLicenseServiceSupplier.get();
        return !jiraLicenseService.isLicenseSet() || !this.licenseJohnsonEventRaiserSupplier.get().checkLicense();
    }

    private void addEventsForErrors(UpgradeResult result) {
        if (this.johnsonEventContainer != null && result != null && !result.successful()) {
            result.getErrors().stream().map(UpgradeLauncher::asUpgradeError).forEach(arg_0 -> ((JohnsonEventContainer)this.johnsonEventContainer).addEvent(arg_0));
        }
    }

    private static Event asUpgradeError(String exception) {
        return new Event(JohnsonEventType.UPGRADE.eventType(), "An error occurred performing JIRA upgrade", exception, EventLevels.error());
    }

    private String constructErrorMessage() {
        String eventDescriptions = this.johnsonEventContainer.getEvents().stream().map(Event::getDesc).collect(Collectors.joining(NEWLINE));
        return "No upgrade is being performed due to detected inconsistencies. " + eventDescriptions;
    }
}

