/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.zdu.DatabaseUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.JiraDelayedUpgradeFailedEvent;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.event.JiraDelayedUpgradeCompletedEvent;
import com.atlassian.jira.index.request.ReindexRequestTypes;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.upgrade.IndexingUpgradeService;
import com.atlassian.jira.upgrade.PluginUpgradeManager;
import com.atlassian.jira.upgrade.UpgradeException;
import com.atlassian.jira.upgrade.UpgradeIndexManager;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeService;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.upgrade.api.UpgradeContext;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeScheduler {
    public static final JobId UPGRADES_JOB_ID = JobId.of((String)UpgradeService.class.getName());
    private static final JobRunnerKey UPGRADES_JOB_RUNNER_KEY = JobRunnerKey.of((String)UpgradeService.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeScheduler.class);
    private final IndexingUpgradeService indexingUpgradeService;
    private final PluginUpgradeManager pluginUpgradeManager;
    private final SchedulerService schedulerService;
    private final EventPublisher eventPublisher;
    private final BuildUtilsInfo buildUtilsInfo;
    private final UpgradeIndexManager upgradeIndexManager;
    private final DatabaseUpgradeStateManager databaseUpgradeStateManager;
    private final ServiceManager serviceManager;

    public UpgradeScheduler(IndexingUpgradeService indexingUpgradeService, PluginUpgradeManager pluginUpgradeManager, SchedulerService schedulerService, EventPublisher eventPublisher, BuildUtilsInfo buildUtilsInfo, UpgradeIndexManager upgradeIndexManager, DatabaseUpgradeStateManager databaseUpgradeStateManager, ServiceManager serviceManager) {
        this.indexingUpgradeService = indexingUpgradeService;
        this.pluginUpgradeManager = pluginUpgradeManager;
        this.schedulerService = schedulerService;
        this.eventPublisher = eventPublisher;
        this.buildUtilsInfo = buildUtilsInfo;
        this.upgradeIndexManager = upgradeIndexManager;
        this.databaseUpgradeStateManager = databaseUpgradeStateManager;
        this.serviceManager = serviceManager;
        this.schedulerService.registerJobRunner(UPGRADES_JOB_RUNNER_KEY, this::runUpgrades);
    }

    private JobRunnerResponse runUpgrades(JobRunnerRequest jobRunnerRequest) {
        if (!this.databaseUpgradeStateManager.areUpgradesAllowedByCluster()) {
            UpgradeState upgradeState = this.databaseUpgradeStateManager.getDatabaseUpgradeState();
            LOGGER.info("Scheduled upgrades cancelled: Upgrades are currently not allowed by the cluster upgrade state (={})", (Object)upgradeState);
            return JobRunnerResponse.aborted((String)("Upgrades are currently not allowed by the cluster upgrade state (=" + upgradeState + ")"));
        }
        try {
            LOGGER.info("Running scheduled upgrades");
            this.runHostUpgrades();
            LOGGER.info("JIRA upgrades completed successfully");
            this.runPluginUpgrades();
            LOGGER.info("Plugins upgrades completed successfully");
            this.upgradeIndexManager.runReindexIfNeededAndAllowed(ReindexRequestTypes.noneAllowed());
            this.eventPublisher.publish((Object)new JiraDelayedUpgradeCompletedEvent(this.buildUtilsInfo.getCurrentBuildNumber()));
            this.serviceManager.refreshAll();
            return JobRunnerResponse.success();
        }
        catch (UpgradeException upgradeException) {
            LOGGER.error("Error occurred during execution of upgrades ", (Throwable)upgradeException);
            this.eventPublisher.publish((Object)new JiraDelayedUpgradeFailedEvent(upgradeException.getUpgradeResult().getErrors()));
            return JobRunnerResponse.failed((String)"An error occurred running the scheduled upgrade tasks");
        }
        catch (Exception exception) {
            LOGGER.error("Error occurred during execution of upgrades ", (Throwable)exception);
            this.eventPublisher.publish((Object)new JiraDelayedUpgradeFailedEvent(Collections.singleton(exception.getMessage())));
            return JobRunnerResponse.failed((String)"An error occurred running the scheduled upgrade tasks");
        }
    }

    private void runHostUpgrades() {
        UpgradeResult upgradeResult = this.indexingUpgradeService.runUpgrades();
        if (!upgradeResult.successful()) {
            throw new UpgradeException(upgradeResult);
        }
    }

    private void runPluginUpgrades() {
        boolean upgradeSuccessful = this.pluginUpgradeManager.upgradePlugins(() -> UpgradeContext.UpgradeTrigger.UPGRADE);
        if (!upgradeSuccessful) {
            throw new UpgradeException(new UpgradeResult("Plugin upgrade(s) failed"));
        }
    }

    public UpgradeResult scheduleUpgrades(int delayInMinutes) {
        Date scheduledDate = DateTime.now().plusMinutes(delayInMinutes).toDate();
        LOGGER.info("Scheduling upgrades to run in {} minute(s)", (Object)delayInMinutes);
        return this.scheduleUpgrades(scheduledDate);
    }

    private UpgradeResult scheduleUpgrades(Date scheduledDate) {
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)UPGRADES_JOB_RUNNER_KEY).withSchedule(Schedule.runOnce((Date)scheduledDate));
        try {
            this.schedulerService.scheduleJob(UPGRADES_JOB_ID, jobConfig);
            return UpgradeResult.OK;
        }
        catch (SchedulerServiceException e) {
            LOGGER.error("Unable to schedule upgrades for future execution :" + (Object)((Object)e), (Throwable)e);
            return new UpgradeResult(this.createErrorMessages((Exception)((Object)e)));
        }
    }

    private Collection<String> createErrorMessages(Exception e) {
        return ImmutableList.of((Object)("Unable to schedule upgrade tasks for future execution: " + e.getMessage() + '\n' + ExceptionUtils.getStackTrace((Throwable)e)));
    }
}

