/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.util.Collection;
import javax.annotation.Nullable;

public interface UpgradeTask {
    public int getBuildNumber();

    public String getShortDescription();

    public void doUpgrade(boolean var1) throws Exception;

    @Nullable
    public Integer dependsUpon();

    public ScheduleOption getScheduleOption();

    public Collection<String> getErrors();

    public boolean isDowngradeTaskRequired();

    public static enum ScheduleOption {
        BEFORE_JIRA_STARTED,
        AFTER_JIRA_STARTED;

    }

    public static class Status {
        private static final JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();

        public static void setTaskDone(String taskId) {
            jiraSystemProperties.setProperty(Status.asPropertyName(taskId), (Object)"true");
        }

        public static boolean isTaskDone(String taskId) {
            return jiraSystemProperties.getProperty(Status.asPropertyName(taskId)) != null;
        }

        private static String asPropertyName(String taskId) {
            return "jira.task." + taskId + ".complete";
        }
    }
}

