/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QEventType;
import com.atlassian.jira.model.querydsl.QNotification;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Arrays;
import java.util.List;

public class UpgradeTask_Build801000
extends AbstractDelayableUpgradeTask {
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build801000(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public int getBuildNumber() {
        return 801000;
    }

    @Override
    public String getShortDescription() {
        return "Adds new jira events for archiving and default notification scheme for them";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.addEventTypes();
        this.addDefaultNotifications();
    }

    private void addEventTypes() {
        if (!this.checkIfPresent(18L)) {
            this.queryDslAccessor.execute(callback -> callback.insert(QEventType.EVENT_TYPE).set((Path)QEventType.EVENT_TYPE.id, (Object)18L).set((Path)QEventType.EVENT_TYPE.name, "Issue Archived").set((Path)QEventType.EVENT_TYPE.description, "This is the 'issue archived' event").set((Path)QEventType.EVENT_TYPE.type, "jira.system.event.type").execute());
        }
        if (!this.checkIfPresent(19L)) {
            this.queryDslAccessor.execute(callback -> callback.insert(QEventType.EVENT_TYPE).set((Path)QEventType.EVENT_TYPE.id, (Object)19L).set((Path)QEventType.EVENT_TYPE.name, "Issue Restored").set((Path)QEventType.EVENT_TYPE.description, "This is the 'issue restored' event").set((Path)QEventType.EVENT_TYPE.type, "jira.system.event.type").execute());
        }
    }

    private boolean checkIfPresent(long id) {
        return this.queryDslAccessor.executeQuery(callback -> ((SQLQuery)((SQLQuery)callback.newSqlQuery().select((Expression)QEventType.EVENT_TYPE).from((Expression)QEventType.EVENT_TYPE)).where((Predicate)QEventType.EVENT_TYPE.id.eq((Object)id))).fetchCount()) > 0L;
    }

    private void addDefaultNotifications() {
        List<NotificationSchemeEntry> entries = Arrays.asList(new NotificationSchemeEntry(10000L, 18L, "Current_Assignee"), new NotificationSchemeEntry(10000L, 18L, "Current_Reporter"), new NotificationSchemeEntry(10000L, 18L, "All_Watchers"), new NotificationSchemeEntry(10000L, 19L, "Current_Assignee"), new NotificationSchemeEntry(10000L, 19L, "Current_Reporter"), new NotificationSchemeEntry(10000L, 19L, "All_Watchers"));
        entries.forEach(entry -> {
            if (!this.checkIfPresent((NotificationSchemeEntry)entry)) {
                this.queryDslAccessor.execute(callback -> callback.insert(QNotification.NOTIFICATION).set((Path)QNotification.NOTIFICATION.scheme, entry.getSchemeId()).set((Path)QNotification.NOTIFICATION.eventTypeId, entry.getEventTypeId()).set((Path)QNotification.NOTIFICATION.type, entry.getType()).executeWithId());
            }
        });
    }

    private boolean checkIfPresent(NotificationSchemeEntry entry) {
        return this.queryDslAccessor.executeQuery(callback -> ((SQLQuery)((SQLQuery)callback.newSqlQuery().select((Expression)QNotification.NOTIFICATION).from((Expression)QNotification.NOTIFICATION)).where((Predicate)QNotification.NOTIFICATION.scheme.eq((Object)entry.getSchemeId()).and((Predicate)QNotification.NOTIFICATION.eventTypeId.eq((Object)entry.getEventTypeId())).and((Predicate)QNotification.NOTIFICATION.type.eq((Object)entry.getType())))).fetchCount()) > 0L;
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    class NotificationSchemeEntry {
        private final Long schemeId;
        private final Long eventTypeId;
        private final String type;

        public NotificationSchemeEntry(Long schemeId, Long eventTypeId, String type) {
            this.schemeId = schemeId;
            this.eventTypeId = eventTypeId;
            this.type = type;
        }

        public Long getSchemeId() {
            return this.schemeId;
        }

        public Long getEventTypeId() {
            return this.eventTypeId;
        }

        public String getType() {
            return this.type;
        }
    }
}

