/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.util;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.health.checks.database.TableColumnCheckResult;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.Transformer;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUtils {
    private static final Logger log = LoggerFactory.getLogger(UpgradeUtils.class);
    private final OfBizDelegator delegator;
    private static final OfBizConnectionFactory factory = DefaultOfBizConnectionFactory.getInstance();
    private static final Pattern FULLY_QUALIFIED_TABLE_NAME = Pattern.compile("(.+\\.)?(.*)");

    public UpgradeUtils(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    public void transformTableColumn(String tableName, String sourceColumn, String targetColumn, Transformer transformer) {
        for (GenericValue row : this.delegator.findAll(tableName)) {
            try {
                Object sourceValue = row.get(sourceColumn);
                if (sourceValue == null) continue;
                Object transformedValue = transformer.transform(sourceValue);
                row.set(targetColumn, transformedValue);
                row.store();
            }
            catch (GenericEntityException e) {
                log.error("Failed to upgrade table row " + row + " exception being thrown", (Throwable)e);
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    public void clearColumn(String tableName, String column) {
        for (GenericValue row : this.delegator.findAll(tableName)) {
            try {
                row.set(column, null);
                row.store();
            }
            catch (GenericEntityException e) {
                log.error("Failed to upgrade table row " + row + " exception being thrown", (Throwable)e);
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tableExists(String tableName) throws DataAccessException {
        boolean bl;
        Connection connection;
        ResultSet tables;
        block7: {
            boolean bl2;
            tables = null;
            connection = null;
            try {
                connection = factory.getConnection();
                if (connection == null) {
                    throw new DataAccessException("Unable to get a database connection for the OfBiz default data source.");
                }
                DatabaseMetaData metaData = connection.getMetaData();
                DatasourceInfo datasourceInfo = factory.getDatasourceInfo();
                String schemaName = datasourceInfo.getSchemaName();
                String schemaPattern = DatabaseUtil.getSchemaPattern((DatabaseMetaData)metaData, (String)schemaName);
                tables = metaData.getTables(connection.getCatalog(), schemaPattern, null, null);
                while (tables.next()) {
                    String currentTableName = tables.getString("TABLE_NAME");
                    if (!UpgradeUtils.areTableNamesEquivalent(tableName, currentTableName)) continue;
                    bl = true;
                    break block7;
                }
                bl2 = false;
            }
            catch (SQLException e) {
                try {
                    throw new DataAccessException((Throwable)e);
                }
                catch (Throwable throwable) {
                    UpgradeUtils.silentlyClose(tables);
                    UpgradeUtils.silentlyClose(connection);
                    throw throwable;
                }
            }
            UpgradeUtils.silentlyClose(tables);
            UpgradeUtils.silentlyClose(connection);
            return bl2;
        }
        UpgradeUtils.silentlyClose(tables);
        UpgradeUtils.silentlyClose(connection);
        return bl;
    }

    @Nullable
    public static String getExactColumnName(String tableName, String columnName) {
        return UpgradeUtils.getColumnInfo(tableName, columnName, rs -> rs.getString("COLUMN_NAME")).orElse(null);
    }

    @Nullable
    public static String getColumnType(String tableName, String columnName) {
        return UpgradeUtils.getColumnInfo(tableName, columnName, rs -> rs.getString("TYPE_NAME")).orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static <T> Optional<T> getColumnInfo(String tableName, String columnName, ColumnMetaDataExtractor<T> valueExtractor) {
        Optional<T> optional;
        Connection connection;
        ResultSet rs;
        block6: {
            Optional optional2;
            rs = null;
            connection = null;
            try {
                connection = factory.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                DatasourceInfo datasourceInfo = factory.getDatasourceInfo();
                String schemaName = datasourceInfo.getSchemaName();
                String schemaPattern = DatabaseUtil.getSchemaPattern((DatabaseMetaData)metaData, (String)schemaName);
                rs = metaData.getColumns(null, schemaPattern, null, null);
                while (rs.next()) {
                    String currentTableName = rs.getString("TABLE_NAME");
                    String exactColumnName = rs.getString("COLUMN_NAME");
                    if (!UpgradeUtils.areTableNamesEquivalent(tableName, currentTableName) || !exactColumnName.equalsIgnoreCase(columnName)) continue;
                    optional = Optional.of(valueExtractor.extract(rs));
                    break block6;
                }
                optional2 = Optional.empty();
            }
            catch (SQLException e) {
                try {
                    throw new DataAccessException((Throwable)e);
                }
                catch (Throwable throwable) {
                    UpgradeUtils.silentlyClose(rs);
                    UpgradeUtils.silentlyClose(connection);
                    throw throwable;
                }
            }
            UpgradeUtils.silentlyClose(rs);
            UpgradeUtils.silentlyClose(connection);
            return optional2;
        }
        UpgradeUtils.silentlyClose(rs);
        UpgradeUtils.silentlyClose(connection);
        return optional;
    }

    public static String getExactTableName(String entityName) {
        String tableName;
        ModelReader modelReader;
        try {
            modelReader = ModelReader.getModelReader((String)factory.getDelegatorName());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        try {
            ModelEntity modelEntity = modelReader.getModelEntity(entityName);
            tableName = modelEntity.getTableName(factory.getDatasourceInfo().getName());
        }
        catch (GenericEntityException e) {
            throw new IllegalArgumentException("EntityName not found: " + entityName + ": " + e.getMessage());
        }
        return tableName;
    }

    private static String stripSchemaPrefix(String tableName) {
        String justTable = tableName;
        Matcher matcher = FULLY_QUALIFIED_TABLE_NAME.matcher(tableName);
        if (matcher.matches()) {
            justTable = matcher.group(2);
        }
        return justTable;
    }

    private static boolean areTableNamesEquivalent(String table1, String table2) {
        return UpgradeUtils.stripSchemaPrefix(table1).equalsIgnoreCase(UpgradeUtils.stripSchemaPrefix(table2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="The string is nonconstant but still safe.")
    public static int getJIRABuildVersionNumber() {
        ResultSet resultSet;
        Connection connection;
        int buildVersionNumber;
        block10: {
            buildVersionNumber = 0;
            connection = null;
            Statement statement = null;
            resultSet = null;
            String osPropertyEntry = UpgradeUtils.getExactTableName("OSPropertyEntry");
            String osPropertyString = UpgradeUtils.getExactTableName("OSPropertyString");
            String psPropertyValue = UpgradeUtils.getExactColumnName(osPropertyString, "propertyvalue");
            String pePropertyKey = UpgradeUtils.getExactColumnName(osPropertyEntry, "property_key");
            String peId = UpgradeUtils.getExactColumnName(osPropertyEntry, "id");
            String psId = UpgradeUtils.getExactColumnName(osPropertyString, "id");
            StringBuilder sql = new StringBuilder();
            try {
                connection = factory.getConnection();
                sql.append("SELECT ps.").append(psPropertyValue).append(" ");
                sql.append("FROM ").append(osPropertyEntry).append(" pe, ").append(osPropertyString).append(" ps ");
                sql.append("WHERE pe.").append(pePropertyKey).append("=").append("'jira.version.patched' ");
                sql.append("AND pe.").append(peId).append("=").append("ps.").append(psId);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sql.toString());
                if (resultSet.next()) {
                    buildVersionNumber = Integer.parseInt(resultSet.getString(psPropertyValue));
                }
                if (statement == null) break block10;
            }
            catch (Exception e) {
                try {
                    log.error("JDBC get version number failed. SQL: " + sql.toString(), (Throwable)e);
                    throw new DataAccessException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    UpgradeUtils.silentlyClose(resultSet);
                    UpgradeUtils.silentlyClose(connection);
                    throw throwable;
                }
            }
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        UpgradeUtils.silentlyClose(resultSet);
        UpgradeUtils.silentlyClose(connection);
        return buildVersionNumber;
    }

    public static void doColumnsOrTablesExist(List<TableColumnCheckResult> tableColumnCheckResults) {
        ResultSet columns = null;
        Connection connection = null;
        try {
            connection = factory.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            DatasourceInfo datasourceInfo = factory.getDatasourceInfo();
            String schemaName = datasourceInfo.getSchemaName();
            String schemaPattern = DatabaseUtil.getSchemaPattern((DatabaseMetaData)metaData, (String)schemaName);
            columns = metaData.getColumns(null, schemaPattern, null, null);
            while (columns.next()) {
                String currentTableName = columns.getString("TABLE_NAME");
                String exactColumnName = columns.getString("COLUMN_NAME");
                for (TableColumnCheckResult tableColumnCheckResult : tableColumnCheckResults) {
                    if (tableColumnCheckResult.isExists() || !UpgradeUtils.areTableNamesEquivalent(tableColumnCheckResult.getTableName(), currentTableName) || tableColumnCheckResult.getColumnName() != null && !exactColumnName.equalsIgnoreCase(tableColumnCheckResult.getColumnName())) continue;
                    tableColumnCheckResult.setExists(true);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                UpgradeUtils.silentlyClose(columns);
                UpgradeUtils.silentlyClose(connection);
                throw throwable;
            }
        }
        UpgradeUtils.silentlyClose(columns);
        UpgradeUtils.silentlyClose(connection);
    }

    private static void silentlyClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void silentlyClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static interface ColumnMetaDataExtractor<T> {
        @Nonnull
        public T extract(ResultSet var1) throws SQLException;
    }
}

