/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.util.stats.LastValueSerializableStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.atlassian.jira.util.stats.TopNSerializableStatsWithFrequencies;
import java.util.concurrent.atomic.AtomicLong;

public interface LoginStats
extends ManagedStats {
    public static final String STATS_NAME = "LOGIN-STATS";

    public void settings(boolean var1, long var2, int var4, String var5);

    public void user(String var1);

    public void beforeUserAuthenticate(long var1);

    public void authentication(boolean var1, long var2);

    public void authenticationCacheGetOrLoad(long var1);

    public void cacheInvalidate();

    public void encodePassword(long var1);

    public void validatePassword(long var1);

    public static LoginStats create() {
        return new MutableLoginStats();
    }

    public static class MutableLoginStats
    implements LoginStats {
        private Settings settings = new Settings();
        private TopNSerializableStatsWithFrequencies<String> topUsers = new TopNSerializableStatsWithFrequencies(1000, 10, 20);
        private MutableLongStats authSuccessfulInMillis = new MutableLongStats(1L, 10L, 100L, 1000L, 5000L);
        private MutableLongStats authFailedInMillis = new MutableLongStats(1L, 10L, 100L, 1000L, 5000L);
        private MutableLongStats authCacheGetOrLoadInMillis = new MutableLongStats(1L, 10L, 100L, 1000L, 5000L);
        private AtomicLong authCacheInvalidation = new AtomicLong();
        private MutableLongStats encodePasswordInMillis = new MutableLongStats(0L, 1L, 5L);
        private MutableLongStats validatePasswordInMillis = new MutableLongStats(0L, 1L, 5L);
        private MutableLongStats beforeUserAuthenticateInMillis = new MutableLongStats(0L, 1L, 10L, 100L, 1000L);

        @Override
        public String getStatsName() {
            return LoginStats.STATS_NAME;
        }

        @Override
        public void settings(boolean legacyMode, long authCacheExpireMin, int authCacheMaxSize, String passwordEncoder) {
            this.settings.legacyMode.store(legacyMode);
            this.settings.authCacheExpireMin.store(authCacheExpireMin);
            this.settings.authCacheMaxSize.store(authCacheMaxSize);
            this.settings.passwordEncoder.store(passwordEncoder);
        }

        @Override
        public void user(String username) {
            this.topUsers.store((Object)username);
        }

        @Override
        public void beforeUserAuthenticate(long timeInMillis) {
            this.beforeUserAuthenticateInMillis.accept(timeInMillis);
        }

        @Override
        public void authentication(boolean successful, long timeInMillis) {
            if (successful) {
                this.authSuccessfulInMillis.accept(timeInMillis);
            } else {
                this.authFailedInMillis.accept(timeInMillis);
            }
        }

        @Override
        public void authenticationCacheGetOrLoad(long timeInMillis) {
            this.authCacheGetOrLoadInMillis.accept(timeInMillis);
        }

        @Override
        public void cacheInvalidate() {
            this.authCacheInvalidation.incrementAndGet();
        }

        @Override
        public void encodePassword(long timeInMillis) {
            this.encodePasswordInMillis.accept(timeInMillis);
        }

        @Override
        public void validatePassword(long timeInMillis) {
            this.validatePasswordInMillis.accept(timeInMillis);
        }

        static class Settings {
            final LastValueSerializableStats<Boolean> legacyMode = new LastValueSerializableStats();
            final LastValueSerializableStats<Long> authCacheExpireMin = new LastValueSerializableStats();
            final LastValueSerializableStats<Integer> authCacheMaxSize = new LastValueSerializableStats();
            final LastValueSerializableStats<String> passwordEncoder = new LastValueSerializableStats();

            Settings() {
            }
        }
    }
}

