/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.a11y;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.a11y.A11yPersonalSetting;
import com.atlassian.jira.user.a11y.A11yPersonalSettingBean;
import com.atlassian.jira.user.a11y.A11yPersonalSettingImage;
import com.atlassian.jira.user.a11y.A11yPersonalSettingImageBean;
import com.atlassian.jira.user.a11y.A11yPersonalSettingModuleDescriptor;
import com.atlassian.jira.user.a11y.A11yPersonalSettingsManager;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class A11yPersonalSettingsManagerImpl
implements A11yPersonalSettingsManager {
    private static final Logger log = LoggerFactory.getLogger(A11yPersonalSettingsManagerImpl.class);
    private final FeatureManager featureManager;
    private final PluginAccessor pluginAccessor;
    private final UserPreferencesManager userPreferencesManager;
    private final JiraAuthenticationContext authenticationContext;
    private final WebResourceUrlProvider webResourceUrlProvider;

    public A11yPersonalSettingsManagerImpl(FeatureManager featureManager, PluginAccessor pluginAccessor, UserPreferencesManager userPreferencesManager, JiraAuthenticationContext authenticationContext, WebResourceUrlProvider webResourceUrlProvider) {
        this.featureManager = featureManager;
        this.pluginAccessor = pluginAccessor;
        this.userPreferencesManager = userPreferencesManager;
        this.authenticationContext = authenticationContext;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    @Override
    @Nonnull
    public List<String> getA11yCssClasses() {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ACCESSIBILITY_PERSONAL_SETTINGS)) {
            return ImmutableList.of();
        }
        return this.getA11yPersonalSettings(false).stream().filter(A11yPersonalSettingBean::isEnabled).map(A11yPersonalSettingBean::getKey).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<A11yPersonalSettingBean> getA11yPersonalSettings() {
        return this.getA11yPersonalSettings(true);
    }

    private List<A11yPersonalSettingBean> getA11yPersonalSettings(boolean loadImages) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(user);
        return this.getSafeAccessViaPluginAccessor().forType(A11yPersonalSettingModuleDescriptor.class, (descriptor, a11YPersonalSetting) -> a11YPersonalSetting).stream().filter(Objects::nonNull).map(a11YPersonalSetting -> {
            String isSettingEnabled = "false";
            try {
                isSettingEnabled = preferences.getString(a11YPersonalSetting.getSettingKey());
            }
            catch (Exception exception) {
                log.warn(String.format("Failed to retrieve accessibility preferences of '%s'", user != null ? user : "anonymous user"), (Throwable)exception);
            }
            return new A11yPersonalSettingBean(a11YPersonalSetting.getSettingKey(), i18n.getText(a11YPersonalSetting.getLabelI18nKey()), i18n.getText(a11YPersonalSetting.getDescriptionI18nKey()), loadImages ? this.getImage((A11yPersonalSetting)a11YPersonalSetting, i18n) : null, "true".equals(isSettingEnabled));
        }).collect(Collectors.toList());
    }

    @Nullable
    private A11yPersonalSettingImageBean getImage(A11yPersonalSetting a11YPersonalSetting, I18nHelper i18n) {
        String imageUrl;
        A11yPersonalSettingImage image = a11YPersonalSetting.getImage();
        if (image == null) {
            return null;
        }
        try {
            imageUrl = this.webResourceUrlProvider.getStaticPluginResourceUrl(image.getCompleteModuleKey(), image.getResourceName(), UrlMode.ABSOLUTE);
        }
        catch (Exception e) {
            log.debug("Failed to get a URL of accessibility preference image", (Throwable)e);
            return null;
        }
        return new A11yPersonalSettingImageBean(imageUrl, i18n.getText(image.getAlternateTextI18nKey()));
    }

    private SafeAccessViaPluginAccessor getSafeAccessViaPluginAccessor() {
        return SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor);
    }
}

