/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AnonymizationResult
implements Serializable {
    private static final long serialVersionUID = -5738092608068388353L;
    public static final String GENERAL = "GENERAL";
    private final Map<String, ErrorCollection> validationErrors;
    private final Map<String, ErrorCollection> validationWarnings;
    private final Set<AnonymizeUserService.AnonymizeOperation> operations;
    private final AnonymizeUserService.OperationsReport<Void> operationsReport;
    private final boolean businessLogicValidationFailed;

    private AnonymizationResult(@Nonnull Map<String, ErrorCollection> validationErrors, @Nonnull Map<String, ErrorCollection> validationWarnings, @Nonnull Set<AnonymizeUserService.AnonymizeOperation> operations, @Nonnull AnonymizeUserService.OperationsReport<Void> operationsReport, boolean businessLogicValidationFailed) {
        this.validationErrors = new HashMap<String, ErrorCollection>(Objects.requireNonNull(validationErrors));
        this.validationErrors.replaceAll((k, v) -> new SimpleErrorCollection(v));
        this.validationWarnings = new HashMap<String, ErrorCollection>(Objects.requireNonNull(validationWarnings));
        this.validationWarnings.replaceAll((k, v) -> new SimpleErrorCollection(v));
        this.operations = Objects.requireNonNull(operations);
        this.operationsReport = Objects.requireNonNull(operationsReport);
        this.businessLogicValidationFailed = businessLogicValidationFailed;
    }

    public static AnonymizationResult from(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        boolean businessLogicValidationFailed;
        Map<String, ErrorCollection> errors = AnonymizationResult.getErrorsFromOperationReport(validationResult.getAffectedEntitiesReport());
        Map<String, ErrorCollection> operationValidationErrors = AnonymizationResult.getErrorsFromOperationReport(validationResult.getOperationValidation());
        operationValidationErrors.forEach((k, v) -> errors.merge((String)k, (ErrorCollection)v, (ov, nv) -> ErrorCollections.join((ErrorCollection[])new ErrorCollection[]{ov, nv})));
        if (validationResult.getErrorCollection().hasAnyErrors()) {
            errors.put(GENERAL, (ErrorCollection)new SimpleErrorCollection(validationResult.getErrorCollection()));
        }
        boolean bl = businessLogicValidationFailed = !validationResult.getBusinessLogicValidationResult().isValid();
        if (businessLogicValidationFailed) {
            errors.putAll(validationResult.getBusinessLogicValidationResult().getHandlerToErrorsMap());
        }
        Map<String, ErrorCollection> validationWarnings = AnonymizationResult.getWarningsFromValidationResult(validationResult);
        return new AnonymizationResult(errors, validationWarnings, AnonymizationResult.getOperations(validationResult), new AnonymizeUserService.OperationsReport<Void>(), businessLogicValidationFailed);
    }

    public static AnonymizationResult from(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull AnonymizeUserService.AnonymizePerformResult performResult) {
        Map<String, ErrorCollection> validationWarnings = AnonymizationResult.getWarningsFromValidationResult(validationResult);
        return new AnonymizationResult(new HashMap<String, ErrorCollection>(), validationWarnings, AnonymizationResult.getOperations(validationResult), performResult.getReport(), false);
    }

    private static Set<AnonymizeUserService.AnonymizeOperation> getOperations(AnonymizeUserService.AnonymizeValidationResult validationResult) {
        return new HashSet<AnonymizeUserService.AnonymizeOperation>(Optional.ofNullable(validationResult.getProcessData()).map(processData -> processData.getOperationsWeWouldLikeToPerform(false)).orElse(Collections.emptyList()));
    }

    @Nonnull
    public AnonymizeUserService.OperationsReport<Void> getOperationsReport() {
        return this.operationsReport;
    }

    @Nonnull
    public Map<String, ErrorCollection> getValidationErrors() {
        return this.validationErrors;
    }

    @Nonnull
    public Map<String, ErrorCollection> getValidationWarnings() {
        return this.validationWarnings;
    }

    @Nonnull
    public Set<AnonymizeUserService.AnonymizeOperation> getOperations() {
        return this.operations;
    }

    public boolean businessLogicValidationFailed() {
        return this.businessLogicValidationFailed;
    }

    @Nonnull
    static Map<String, ErrorCollection> getErrorsFromOperationReport(@Nonnull AnonymizeUserService.OperationsReport<?> operationsReport) {
        HashMap<String, ErrorCollection> ret = new HashMap<String, ErrorCollection>();
        operationsReport.getReports().stream().filter(report -> report.getResult().getErrorCollection().hasAnyErrors()).forEach(report -> ret.merge(report.getOperation().toString(), (ErrorCollection)new SimpleErrorCollection(report.getResult().getErrorCollection()), (o, n) -> ErrorCollections.join((ErrorCollection[])new ErrorCollection[]{o, n})));
        return ret;
    }

    @Nonnull
    static Map<String, ErrorCollection> getWarningsFromValidationResult(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> operationsReport = validationResult.getAffectedEntitiesReport();
        Map<String, ErrorCollection> warningMap = operationsReport.getReports().stream().flatMap(report -> report.getResult().getWarnings().entrySet().stream()).filter(entrySet -> ((ErrorCollection)entrySet.getValue()).hasAnyErrors()).collect(Collectors.toMap(Map.Entry::getKey, entry -> new SimpleErrorCollection((ErrorCollection)entry.getValue())));
        if (validationResult.hasWarnings()) {
            warningMap.put(GENERAL, (ErrorCollection)new SimpleErrorCollection(validationResult.getWarnings()));
        }
        return warningMap;
    }
}

