/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationHandlerExecutedEvent;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizationHandler;
import com.atlassian.jira.user.anonymize.AnonymizationHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.BusinessLogicValidationResult;
import com.atlassian.jira.user.anonymize.BusinessLogicValidator;
import com.atlassian.jira.user.anonymize.TaskContextAware;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserPropertyChangeManager<T extends AnonymizationHandler<P>, P extends TaskContextAware> {
    private static Logger log = LoggerFactory.getLogger(UserPropertyChangeManager.class);
    private final PluginAccessor pluginAccessor;
    protected final EventPublisher eventPublisher;
    private final BusinessLogicValidator businessLogicValidator;
    private static final Comparator<AnonymizationHandlerModuleDescriptor> comparingByOrder = Comparator.comparing(AnonymizationHandlerModuleDescriptor::getOrder);
    private static final Comparator<AnonymizationHandlerModuleDescriptor> comparingByOrderAndKey = comparingByOrder.thenComparing(md -> StringUtils.defaultString((String)md.getKey()));

    public UserPropertyChangeManager(PluginAccessor pluginAccessor, EventPublisher eventPublisher, BusinessLogicValidator businessLogicValidator) {
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
        this.businessLogicValidator = businessLogicValidator;
    }

    public abstract void changeProperty(@Nonnull P var1);

    protected abstract Class<? extends AnonymizationHandlerModuleDescriptor<T, P>> getModuleDescriptorClass();

    @Nonnull
    public Map<AnonymizationHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>> getAffectedEntities(@Nonnull P parameter) {
        LinkedHashMap<AnonymizationHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>> response = new LinkedHashMap<AnonymizationHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>>();
        List<AnonymizationHandlerModuleDescriptor<T, P>> handlers = this.getModuleDescriptorsForHandlers();
        log.info("User property change handlers count: {}", (Object)handlers.size());
        for (AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor : handlers) {
            response.put(handlerModuleDescriptor, this.getAffectedEntitiesFromHandler(handlerModuleDescriptor, parameter));
        }
        return response;
    }

    @Nonnull
    public Map<AnonymizationHandlerModuleDescriptor, ServiceResult> executeHandlers(@Nonnull P parameter, @Nonnull I18nHelper i18nBean) {
        HashMap<AnonymizationHandlerModuleDescriptor, ServiceResult> response = new HashMap<AnonymizationHandlerModuleDescriptor, ServiceResult>();
        List<AnonymizationHandlerModuleDescriptor<T, P>> handlers = this.getModuleDescriptorsForHandlers();
        log.info("User property change handlers count: {}", (Object)handlers.size());
        for (AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor : handlers) {
            response.put(handlerModuleDescriptor, this.executeHandler(handlerModuleDescriptor, parameter, i18nBean));
        }
        return response;
    }

    int getNumberOfTasks(@Nonnull P userPropertyChangeParameter) {
        return this.getModuleDescriptorsForHandlers().stream().mapToInt(moduleDescriptor -> this.getNumberOfTasksFromHandler((AnonymizationHandlerModuleDescriptor<T, P>)((Object)moduleDescriptor), userPropertyChangeParameter)).sum();
    }

    @Nonnull
    public BusinessLogicValidationResult validateBusinessLogic(@Nonnull AnonymizationParameters anonymizationParameters) {
        return this.businessLogicValidator.validate(this.getModuleDescriptorsForHandlers(), anonymizationParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumberOfTasksFromHandler(@Nonnull AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor, @Nonnull P userPropertyChangeParameter) {
        boolean success = true;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            int n = ((AnonymizationHandler)handlerModuleDescriptor.getModule()).getNumberOfTasks(userPropertyChangeParameter);
            return n;
        }
        catch (Exception e) {
            success = false;
            log.warn("Exception during getting number of tasks for handler: {}", handlerModuleDescriptor, (Object)e);
            int n = 1000;
            return n;
        }
        finally {
            this.eventPublisher.publish((Object)UserAnonymizationHandlerExecutedEvent.numberOfTasks((String)handlerModuleDescriptor.getPluginKey(), (String)handlerModuleDescriptor.getKey(), (boolean)success, (Duration)stopwatch.elapsed()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected ServiceOutcome<Collection<AffectedEntity>> getAffectedEntitiesFromHandler(@Nonnull AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor, @Nonnull P userPropertyChangeParameter) {
        AnonymizationHandler handler = (AnonymizationHandler)handlerModuleDescriptor.getModule();
        log.info("Getting affected entities for handler: {}", handlerModuleDescriptor);
        boolean success = true;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Collection affectedEntities = this.retryOnException(() -> handler.getAffectedEntities(userPropertyChangeParameter), 1);
            ServiceOutcomeImpl<Collection<AffectedEntity>> serviceOutcomeImpl = ServiceOutcomeImpl.ok(affectedEntities);
            return serviceOutcomeImpl;
        }
        catch (Exception e) {
            success = false;
            log.error("Exception during getting affected entities for handler: {}", handlerModuleDescriptor, (Object)e);
            ServiceOutcomeImpl<Collection<AffectedEntity>> serviceOutcomeImpl = ServiceOutcomeImpl.error(e.getMessage());
            return serviceOutcomeImpl;
        }
        finally {
            log.info("Ending getting affected entities for handler: {}, took {}", handlerModuleDescriptor, (Object)stopwatch);
            this.eventPublisher.publish((Object)UserAnonymizationHandlerExecutedEvent.affectedEntities((String)handlerModuleDescriptor.getPluginKey(), (String)handlerModuleDescriptor.getKey(), (boolean)success, (Duration)stopwatch.elapsed()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nonnull
    protected ServiceResult executeHandler(@Nonnull AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor, @Nonnull P userPropertyChangeParameter, @Nonnull I18nHelper i18nBean) {
        AnonymizationHandler handler = (AnonymizationHandler)handlerModuleDescriptor.getModule();
        log.info("Starting task for handler: {}", handlerModuleDescriptor);
        boolean success = true;
        Stopwatch stopwatch = Stopwatch.createStarted();
        Context taskContext = userPropertyChangeParameter.getContext();
        try {
            ServiceResult serviceResult;
            Object object;
            Context.Task task;
            block19: {
                block20: {
                    task = taskContext.start((Object)handler);
                    object = null;
                    taskContext.setName(i18nBean.getText("admin.user.property.change.processing.handler", handlerModuleDescriptor.getDisplayName()));
                    ServiceResult handlerResponse = this.retryOnException(() -> handler.update(userPropertyChangeParameter), 1);
                    if (!handlerResponse.isValid()) {
                        log.info("Ending task (error) for handler: {}, ({}), took {}", new Object[]{handlerModuleDescriptor, handlerResponse.getErrorCollection(), stopwatch});
                    } else {
                        log.info("Ending task (success) for handler: {}, took {}", handlerModuleDescriptor, (Object)stopwatch);
                    }
                    serviceResult = handlerResponse;
                    if (task == null) break block19;
                    if (object == null) break block20;
                    try {
                        task.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block19;
                }
                task.close();
            }
            return serviceResult;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (task != null) {
                            if (object != null) {
                                try {
                                    task.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                task.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    success = false;
                    log.error("Exception during AnonymizationHandler {} processing", handlerModuleDescriptor, (Object)e);
                    object = ServiceOutcomeImpl.error(e.getMessage());
                    return object;
                }
            }
        }
        finally {
            this.eventPublisher.publish((Object)UserAnonymizationHandlerExecutedEvent.update((String)handlerModuleDescriptor.getPluginKey(), (String)handlerModuleDescriptor.getKey(), (boolean)success, (Duration)stopwatch.elapsed()));
        }
    }

    private List<? extends AnonymizationHandlerModuleDescriptor<T, P>> getModuleDescriptorsForHandlers() {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(this.getModuleDescriptorClass());
        return moduleDescriptors.stream().filter(module -> module.getOrder() >= 0).sorted(comparingByOrderAndKey).collect(Collectors.toList());
    }

    private <U> U retryOnException(@Nonnull Callable<U> callable, int retries) throws Exception {
        int attempt = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (IOException ioe) {
                IOException lastException = ioe;
                log.warn("Exception during handler execution", (Throwable)ioe);
                if (++attempt <= retries) continue;
                throw lastException;
            }
            break;
        }
    }
}

