/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.anonymize;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class ProjectRoleAnonymizationHandler
implements UserAnonymizationHandler {
    private final ProjectRoleService projectRoleService;

    public ProjectRoleAnonymizationHandler(ProjectRoleService projectRoleService) {
        this.projectRoleService = projectRoleService;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserAnonymizationParameter parameter) {
        SimpleErrorCollection error = new SimpleErrorCollection();
        long projects = this.projectRoleService.getProjectsContainingRoleActorByNameAndType(parameter.getUserKey(), "atlassian-user-role-actor", (ErrorCollection)error).size();
        if (projects > 0L) {
            return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.REMOVE).descriptionKey("user.anonymization.handler.project.roles.description").numberOfOccurrences(Long.valueOf(projects)).build());
        }
        return ImmutableList.of();
    }

    @Nonnull
    public ServiceResult update(@Nonnull UserAnonymizationParameter parameter) {
        SimpleErrorCollection error = new SimpleErrorCollection();
        try {
            this.projectRoleService.removeAllRoleActorsByNameAndType(parameter.getUserKey(), "atlassian-user-role-actor", (ErrorCollection)error);
        }
        finally {
            ContextUtil.updateProgress(parameter.getContext(), this.getNumberOfTasks(parameter));
        }
        return new ServiceResultImpl((ErrorCollection)error);
    }

    public int getNumberOfTasks(@Nonnull UserAnonymizationParameter userPropertyChangeParameter) {
        return 1;
    }
}

