/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.AdditionalAnonymizationData;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.key.IssueHistoryUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.MultiUserFieldHistoryInfo;
import com.atlassian.jira.user.anonymize.handlers.utils.MultiUserPickerSanitizer;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHistoryCustomFieldMultiUserKeyChangeHandler
extends IssueHistoryUserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryCustomFieldMultiUserKeyChangeHandler.class);
    private static final String NAME_PREFIX_KEY = "anonymization.fk.prefix";
    protected static final String ENTITY_NAME = "issueHistory.customField";

    public IssueHistoryCustomFieldMultiUserKeyChangeHandler(JiraAuthenticationContext jiraAuthenticationContext, QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, int stepNumber) {
        super(jiraAuthenticationContext, queryDslAccessor, databaseAccessor, stepNumber, (List<IssueHistoryInfo>)ImmutableList.of((Object)new MultiUserFieldHistoryInfo(QChangeItem.CHANGE_ITEM.oldvalue, QChangeItem.CHANGE_ITEM.oldstring), (Object)new MultiUserFieldHistoryInfo(QChangeItem.CHANGE_ITEM.newvalue, QChangeItem.CHANGE_ITEM.newstring)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        String original = userPropertyChangeParameter.getOriginal();
        String target = userPropertyChangeParameter.getTarget();
        String name = this.jiraAuthenticationContext.getI18nHelper().getText(NAME_PREFIX_KEY, ENTITY_NAME);
        userPropertyChangeParameter.getContext().setName(name);
        String fullNameOriginal = this.getFullNameOriginal(userPropertyChangeParameter);
        try {
            long updated = this.getInfos().stream().mapToLong(arg_0 -> this.lambda$update$1(original, target, fullNameOriginal, (ErrorCollection)errors, arg_0)).sum();
            log.info("Updated {} {} entities for {}", new Object[]{updated, QChangeItem.CHANGE_ITEM.getTableName(), original});
        }
        finally {
            ContextUtil.updateProgress(userPropertyChangeParameter.getContext(), this.getNumberOfTasks(userPropertyChangeParameter));
        }
        return new ServiceResultImpl((ErrorCollection)errors);
    }

    @Nonnull
    private String getFullNameOriginal(UserPropertyChangeParameter userPropertyChangeParameter) {
        String fullNameOriginal = userPropertyChangeParameter.getOriginal();
        if (userPropertyChangeParameter instanceof AdditionalAnonymizationData) {
            fullNameOriginal = ((AdditionalAnonymizationData)userPropertyChangeParameter).getFullName().orElse(fullNameOriginal);
        }
        return fullNameOriginal;
    }

    private long updateCustomField(Long id, IssueHistoryInfo info, String original, String target, String fullNameOriginal) {
        return this.queryDslAccessor.executeQuery(connection -> {
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(new Expression[]{info.getColumn(), info.getColumnHumanReadable()}).from((Expression)info.getTable())).where((Predicate)QChangeItem.CHANGE_ITEM.id.eq((Object)id))).fetchFirst();
            String dbValue = StringUtils.defaultString((String)((String)tuple.get(info.getColumn())));
            String humanReadableValue = StringUtils.defaultString((String)((String)tuple.get((Expression)info.getColumnHumanReadable())));
            MultiUserPickerSanitizer multiUserPickerSanitizer = new MultiUserPickerSanitizer(dbValue, humanReadableValue, fullNameOriginal, original, target);
            String newDbValue = multiUserPickerSanitizer.getDbValueSanitized();
            String newHumanReadableValue = multiUserPickerSanitizer.getHumanReadableValueSanitized();
            return connection.update((RelationalPath<?>)info.getTable()).set(info.getColumn(), (Object)newDbValue).set((Path)info.getColumnHumanReadable(), (Object)newHumanReadableValue).where((Predicate)QChangeItem.CHANGE_ITEM.id.eq((Object)id)).execute();
        });
    }

    private /* synthetic */ long lambda$update$1(String original, String target, String fullNameOriginal, ErrorCollection errors, IssueHistoryInfo info) {
        return this.getAffectedEntitiesIds(original, info).stream().mapToLong(id -> {
            try {
                return this.updateCustomField((Long)id, info, original, target, fullNameOriginal);
            }
            catch (Exception e) {
                log.error(String.format("Exception during multiuserpicker update %d", id), (Throwable)e);
                errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("change.handler.processing.exception", e.getMessage()));
                return 0L;
            }
        }).sum();
    }
}

