/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key.info;

import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.QueryDslUtils;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.user.anonymize.handlers.key.info.ForeignKeyInfo;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IssueHistoryInfo
implements ForeignKeyInfo {
    protected String field;
    protected StringPath columnDbKeys;
    protected StringPath columnHumanReadable;

    public IssueHistoryInfo(@Nonnull String field, @Nonnull StringPath columnDbKeys, @Nonnull StringPath columnHumanReadable) {
        this.field = Objects.requireNonNull(field);
        this.columnDbKeys = Objects.requireNonNull(columnDbKeys);
        this.columnHumanReadable = Objects.requireNonNull(columnHumanReadable);
    }

    @Override
    public Path<String> getColumn() {
        return this.columnDbKeys;
    }

    @Nonnull
    public StringPath getColumnHumanReadable() {
        return this.columnHumanReadable;
    }

    @Override
    public NumberPath<Long> getSelect() {
        return QChangeItem.CHANGE_ITEM.id;
    }

    @Override
    public JiraRelationalPathBase getTable() {
        return QChangeItem.CHANGE_ITEM;
    }

    @Override
    public Predicate getWhere(String original) {
        return this.getWhere(original, null);
    }

    public Predicate getWhere(String original, @Nullable DatabaseVendor databaseVendor) {
        BooleanExpression columnEquals = this.columnDbKeys.eq((Object)original);
        if (DatabaseVendor.SQL_SERVER.equals((Object)databaseVendor)) {
            columnEquals = QueryDslUtils.mssqlCastNTextToNvarchar(this.columnDbKeys).eq((Object)original);
        } else if (DatabaseVendor.ORACLE.equals((Object)databaseVendor)) {
            columnEquals = QueryDslUtils.oracleCastClobToNvarchar(this.columnDbKeys).eq((Object)original);
        }
        return QChangeItem.CHANGE_ITEM.fieldtype.eq((Object)"jira").and((Predicate)QChangeItem.CHANGE_ITEM.field.eq((Object)this.field).and((Predicate)columnEquals));
    }

    @Override
    public String getDescription() {
        return "issueHistory.userKey";
    }
}

