/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.username.mention;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserNameChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.username.mention.AnonymizeMentionsCommand;
import com.atlassian.jira.user.anonymize.handlers.username.mention.MentionsGetAffectedEntitiesCommand;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MentionUsernameChangeHandler
implements UserNameChangeHandler {
    private final MentionsGetAffectedEntitiesCommand[] getAffectedEntitiesCommands;
    private final AnonymizeMentionsCommand[] anonymizeCommands;

    public MentionUsernameChangeHandler(MentionsGetAffectedEntitiesCommand[] getAffectedEntitiesCommands, AnonymizeMentionsCommand[] anonymizeCommands) {
        this.getAffectedEntitiesCommands = getAffectedEntitiesCommands;
        this.anonymizeCommands = anonymizeCommands;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(UserPropertyChangeParameter parameter) {
        return Arrays.stream(this.getAffectedEntitiesCommands).flatMap(command -> command.getAffectedEntities(parameter).stream()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(UserPropertyChangeParameter parameter) {
        ProgressReporter progressReporter = new ProgressReporter(parameter.getContext(), this.getNumberOfTasks(parameter), this.anonymizeCommands.length);
        try {
            ServiceResult serviceResult = Arrays.stream(this.anonymizeCommands).map(command -> command.execute(parameter)).map(result -> this.reportStepCompleted((ServiceResult)result, progressReporter)).reduce((ServiceResult)new ServiceResultImpl(), this::reduceServiceResults);
            return serviceResult;
        }
        finally {
            progressReporter.reportAllTasksCompleted();
        }
    }

    private ServiceResult reduceServiceResults(ServiceResult acc, ServiceResult other) {
        acc.getWarningCollection().addWarnings(other.getWarningCollection());
        acc.getErrorCollection().addErrorCollection(other.getErrorCollection());
        return acc;
    }

    private ServiceResult reportStepCompleted(ServiceResult result, ProgressReporter progressReporter) {
        progressReporter.reportStepCompleted();
        return result;
    }

    private static class ProgressReporter {
        private final int taskCompletionStep;
        private final Context context;
        private final int totalProgressToReport;
        private int progress = 0;

        ProgressReporter(Context context, int totalProgressToReport, int tasksCount) {
            this.context = context;
            this.totalProgressToReport = totalProgressToReport;
            this.taskCompletionStep = tasksCount == 0 ? 0 : totalProgressToReport / tasksCount;
        }

        void reportStepCompleted() {
            this.progress += this.taskCompletionStep;
            ContextUtil.updateProgress(this.context, this.taskCompletionStep);
        }

        private void reportAllTasksCompleted() {
            ContextUtil.updateProgress(this.context, Math.max(0, this.totalProgressToReport - this.progress));
            this.progress = this.totalProgressToReport;
        }
    }
}

