/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.username.mention.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.GenericConfigurationDTO;
import com.atlassian.jira.model.querydsl.QGenericConfiguration;
import com.atlassian.jira.user.anonymize.handlers.username.events.CustomFieldDefaultValueChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.username.mention.AnonymizeMentionsCommand;
import com.atlassian.jira.user.anonymize.handlers.username.mention.MentionAnonymizationContext;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.text.StringEscapeUtils;

@ParametersAreNonnullByDefault
public class ChangeMentionsInTextCustomFieldsDefaultValue
implements AnonymizeMentionsCommand.Worker<GenericConfigurationDTO> {
    private final EventPublisher eventPublisher;

    public ChangeMentionsInTextCustomFieldsDefaultValue(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void executeUpdateEntityQuery(GenericConfigurationDTO entity, QueryDslAccessor queryDslAccessor, MentionAnonymizationContext ctx) {
        queryDslAccessor.executeQuery(con -> con.update((RelationalPath<?>)QGenericConfiguration.GENERIC_CONFIGURATION).set((Path)QGenericConfiguration.GENERIC_CONFIGURATION.xmlvalue, (Object)ctx.withUsernameMapper(StringEscapeUtils::escapeXml11).anonymizeMentions(entity.getXmlvalue())).where((Predicate)QGenericConfiguration.GENERIC_CONFIGURATION.id.eq((Object)entity.getId())).execute());
    }

    @Override
    public String getSavingErrorMessageKey() {
        return "anonymization.username.text.custom.field.default.value.mention.saving.error";
    }

    @Override
    public void afterUpdates() {
        this.eventPublisher.publish((Object)new CustomFieldDefaultValueChangedEvent());
    }
}

