/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.BusinessLogicValidationResult;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.ServiceResultWithWarnings;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameterWithAdditionalData;
import com.atlassian.jira.user.anonymize.UserAnonymizationService;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.user.anonymize.operations.StepWithPluginPointInvocations;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymizePluginPointsStep
implements AnonymizeOperationStep,
StepWithPluginPointInvocations {
    private static final Logger log = LoggerFactory.getLogger(AnonymizePluginPointsStep.class);
    private final UserAnonymizationService userAnonymizationService;

    public AnonymizePluginPointsStep(UserAnonymizationService userAnonymizationService) {
        this.userAnonymizationService = userAnonymizationService;
    }

    @Override
    @Nonnull
    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(@Nonnull AnonymizeUserService.OperationsReport<Void> anonymizeReport, @Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        if (!this.shouldPerformOperation(processData)) {
            log.info("Skipping anonymizing in extension points");
            return Optional.empty();
        }
        Optional<UserAnonymizationParameter> userAnonymizationParameterOptional = this.getUserAnonymizationParameter(processData, asyncTaskContext);
        if (!userAnonymizationParameterOptional.isPresent()) {
            log.warn("No parameter present. Skipping anonymizing in extension points");
            return Optional.empty();
        }
        UserAnonymizationParameter parameter = userAnonymizationParameterOptional.get();
        log.info("Anonymizing in extension points for {}", (Object)parameter);
        UserPropertyChangeService.UserPropertyChangeValidationResult<UserAnonymizationParameter> operationValidationResult = this.userAnonymizationService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserAnonymizationParameter>(validationResult.getRequest().getExecutor(), parameter));
        if (!operationValidationResult.isValid()) {
            return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, operationValidationResult.getErrorCollection(), (Map<String, ErrorCollection>)ImmutableMap.of())));
        }
        ServiceResultWithWarnings result = this.userAnonymizationService.userPropertyChangeInOtherEntities(operationValidationResult);
        return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, result.getErrorCollection(), result.getWarnings())));
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, I18nHelper i18nHelper, boolean preValidate) {
        return ServiceOutcomeImpl.ok(null);
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        UserAnonymizationParameter parameter = this.getUserAnonymizationParameterForAffectedEntities(anonymizationData);
        return this.userAnonymizationService.getAffectedEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserAnonymizationParameter>(anonymizationData.getAnonymizationParameters().getExecutor(), parameter));
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS;
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        Optional<UserAnonymizationParameter> userAnonymizationParameter = this.getUserAnonymizationParameter(processData, Contexts.nullContext());
        return userAnonymizationParameter.map(this.userAnonymizationService::getNumberOfTasks).orElse(0);
    }

    @Nonnull
    private Optional<UserAnonymizationParameter> getUserAnonymizationParameter(@Nullable AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, @Nonnull Context asyncTaskContext) {
        if (anonymizationProcessData == null) {
            return Optional.empty();
        }
        String displayName = Optional.ofNullable(anonymizationProcessData.getUser()).map(ApplicationUser::getDisplayName).orElse(null);
        if (anonymizationProcessData.isUserKeyAlreadyAnonymized() && StringUtils.isNotBlank((CharSequence)anonymizationProcessData.getOldUserKey())) {
            return Optional.of(new UserAnonymizationParameterWithAdditionalData(anonymizationProcessData.getOldUserKey(), displayName, asyncTaskContext));
        }
        if (anonymizationProcessData.getUser() == null) {
            return Optional.empty();
        }
        return Optional.of(new UserAnonymizationParameterWithAdditionalData(anonymizationProcessData.getUser().getKey(), displayName, asyncTaskContext));
    }

    @Nonnull
    private UserAnonymizationParameter getUserAnonymizationParameterForAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationProcessData) {
        return this.getUserAnonymizationParameter(anonymizationProcessData, Contexts.nullContext()).orElseGet(() -> new UserAnonymizationParameterWithAdditionalData(anonymizationProcessData.getAnonymizationParameters().getUserKey(), Optional.ofNullable(anonymizationProcessData.getUser()).map(ApplicationUser::getDisplayName).orElse(null), Contexts.nullContext()));
    }

    @Override
    @Nonnull
    public BusinessLogicValidationResult validateBusinessLogic(@Nonnull AnonymizationParameters anonymizationParameters) {
        return this.userAnonymizationService.validateBusinessLogic(anonymizationParameters);
    }
}

