/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.BusinessLogicValidationResult;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.ServiceResultWithWarnings;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.name.UserNameChangeService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.user.anonymize.operations.StepWithPluginPointInvocations;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserNameChangePluginPointsOperationStep
implements AnonymizeOperationStep,
StepWithPluginPointInvocations {
    private static final Logger log = LoggerFactory.getLogger(UserNameChangePluginPointsOperationStep.class);
    private final UserNameChangeService userNameChangeService;

    public UserNameChangePluginPointsOperationStep(UserNameChangeService userNameChangeService) {
        this.userNameChangeService = userNameChangeService;
    }

    @Override
    @Nonnull
    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(@Nonnull AnonymizeUserService.OperationsReport<Void> anonymizeReport, @Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        if (!this.shouldPerformOperation(processData)) {
            log.info("Skipping changing user name in extension points");
            return Optional.empty();
        }
        Optional<UserPropertyChangeParameter> userNameChangeParameterOptional = this.getUserNameChangeParameterForHandlers(processData, asyncTaskContext);
        if (!userNameChangeParameterOptional.isPresent()) {
            log.warn("No parameter present. Skipping changing username in extension points");
            return Optional.empty();
        }
        Optional<AnonymizeUserService.SingleOperationReport<Void>> changeUserNameReport = anonymizeReport.getReport(AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE);
        if (changeUserNameReport.isPresent() && !changeUserNameReport.get().isValid()) {
            log.info("Skipping changing user name in extension points - user name change operation failed, no need to call extension points");
            return Optional.empty();
        }
        UserPropertyChangeParameter userNameChangeParameter = userNameChangeParameterOptional.get();
        log.info("Changing username in extension points for {}", (Object)userNameChangeParameter);
        UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> userNameChangeValidationResult = this.userNameChangeService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(validationResult.getRequest().getExecutor(), userNameChangeParameter));
        if (!userNameChangeValidationResult.isValid()) {
            return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, userNameChangeValidationResult.getErrorCollection(), new HashMap<String, ErrorCollection>())));
        }
        ServiceResultWithWarnings operationResult = this.userNameChangeService.userPropertyChangeInOtherEntities(userNameChangeValidationResult);
        return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, operationResult.getErrorCollection(), operationResult.getWarnings())));
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        UserPropertyChangeParameter parameter = this.getUserNameChangeParameterForAffectedEntities(anonymizationData);
        log.info("Getting user name change affected entities for {}", (Object)parameter);
        AnonymizationParameters request = anonymizationData.getAnonymizationParameters();
        return this.userNameChangeService.getAffectedEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(request.getExecutor(), parameter));
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationData, I18nHelper i18nHelper, boolean preValidate) {
        if (preValidate) {
            return ServiceOutcomeImpl.ok(null);
        }
        AnonymizationParameters request = anonymizationData.getAnonymizationParameters();
        if (anonymizationData.getUser() == null) {
            return ServiceOutcomeImpl.error(i18nHelper.getText("admin.errors.user.anonymize.no.user"));
        }
        if (anonymizationData.isUserNameAlreadyAnonymized()) {
            if (request.isRerunPluginPoints()) {
                return this.userNameChangeService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(request.getExecutor(), new UserPropertyChangeParameter(StringUtils.defaultString((String)anonymizationData.getOldUserName()), StringUtils.defaultString((String)anonymizationData.getUser().getUsername()), Contexts.nullContext())));
            }
        } else {
            return this.userNameChangeService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(request.getExecutor(), new UserPropertyChangeParameter(StringUtils.defaultString((String)anonymizationData.getUser().getUsername()), StringUtils.defaultString((String)anonymizationData.getNewUserName()), Contexts.nullContext())));
        }
        return ServiceOutcomeImpl.ok(null);
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        Optional<UserPropertyChangeParameter> userNameChangeParameterOptional = this.getUserNameChangeParameterForHandlers(validationResult.getProcessData(), Contexts.nullContext());
        return userNameChangeParameterOptional.map(this.userNameChangeService::getNumberOfTasks).orElse(0);
    }

    @Override
    @Nonnull
    public BusinessLogicValidationResult validateBusinessLogic(@Nonnull AnonymizationParameters anonymizationParameters) {
        return this.userNameChangeService.validateBusinessLogic(anonymizationParameters);
    }

    @Nonnull
    private Optional<UserPropertyChangeParameter> getUserNameChangeParameterForHandlers(@Nullable AnonymizeUserService.AnonymizeProcessData anonymizationData, @Nonnull Context asyncTaskContext) {
        if (anonymizationData == null || anonymizationData.getUser() == null) {
            return Optional.empty();
        }
        AnonymizationParameters request = anonymizationData.getAnonymizationParameters();
        if (anonymizationData.isUserNameAlreadyAnonymized()) {
            String oldUserName;
            if (request.isRerunPluginPoints() && !StringUtils.isBlank((CharSequence)(oldUserName = anonymizationData.getOldUserName()))) {
                return Optional.of(new UserPropertyChangeParameter(oldUserName, anonymizationData.getUser().getUsername(), asyncTaskContext));
            }
        } else if (!StringUtils.isBlank((CharSequence)anonymizationData.getNewUserName())) {
            return Optional.of(new UserPropertyChangeParameter(anonymizationData.getUser().getUsername(), anonymizationData.getNewUserName(), asyncTaskContext));
        }
        return Optional.empty();
    }

    private UserPropertyChangeParameter getUserNameChangeParameterForAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        return this.getUserNameChangeParameterForHandlers(anonymizationData, Contexts.nullContext()).orElseGet(() -> new UserPropertyChangeParameter(anonymizationData.getAnonymizationParameters().getUserKey(), anonymizationData.getAnonymizationParameters().getUserKey(), Contexts.nullContext()));
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE_PLUGIN_POINTS;
    }
}

