/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.profile.ViewProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.profile.ActivityUserProfileFragment;
import com.atlassian.jira.user.profile.InlineActivityUserProfileFragment;
import com.atlassian.jira.user.profile.PluggableUserProfileFragment;
import com.atlassian.jira.user.profile.UserProfileFragment;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryUserProfilePanel
implements ViewProfilePanel {
    private static final Logger log = LoggerFactory.getLogger(SummaryUserProfilePanel.class);
    private ViewProfilePanelModuleDescriptor moduleDescriptor;
    private final JiraAuthenticationContext context;
    private final SearchService searchService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final PluginAccessor pluginAccessor;
    private final VelocityTemplatingEngine templatingEngine;
    private final VelocityParamFactory velocityParamFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final FieldVisibilityManager fieldVisibiltyManager;
    private final ApplicationProperties applicationProperties;
    private final WebInterfaceManager webInterfaceManager;
    private final FeatureManager featureManager;
    private final SoyTemplateRendererProvider soyTemplateRendererProvider;
    private VelocityRequestContext requestContext;
    private PluggableUserProfileFragment pluggablePanel;

    public SummaryUserProfilePanel(JiraAuthenticationContext context, SearchService searchService, VelocityRequestContextFactory velocityRequestContextFactory, PluginAccessor pluginAccessor, VelocityTemplatingEngine templatingEngine, VelocityParamFactory velocityParamFactory, I18nHelper.BeanFactory i18nFactory, ApplicationProperties applicationProperties1, FieldVisibilityManager fieldVisibiltyManager, WebInterfaceManager webInterfaceManager, FeatureManager featureManager, SoyTemplateRendererProvider soyTemplateRendererProvider) {
        this.context = context;
        this.searchService = searchService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.pluginAccessor = pluginAccessor;
        this.templatingEngine = templatingEngine;
        this.velocityParamFactory = velocityParamFactory;
        this.i18nFactory = i18nFactory;
        this.fieldVisibiltyManager = fieldVisibiltyManager;
        this.applicationProperties = applicationProperties1;
        this.webInterfaceManager = webInterfaceManager;
        this.featureManager = featureManager;
        this.soyTemplateRendererProvider = soyTemplateRendererProvider;
    }

    public void init(ViewProfilePanelModuleDescriptor moduleDescriptor) {
        this.requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        this.moduleDescriptor = moduleDescriptor;
        this.pluggablePanel = new PluggableUserProfileFragment(this.context, this.templatingEngine, this.velocityParamFactory, this.webInterfaceManager);
    }

    public String getHtml(ApplicationUser profileUser) {
        return this.moduleDescriptor.getHtml("view", this.getParams(profileUser));
    }

    private Map<String, Object> getParams(ApplicationUser profileUser) {
        ApplicationUser currentUser = this.context.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("filters", this.getFilters(profileUser, currentUser));
        UserProfileFragment fragment = this.featureManager.isEnabled("com.atlassian.streams.InlineActivityStream") ? new InlineActivityUserProfileFragment(this.pluginAccessor, this.i18nFactory, this.soyTemplateRendererProvider.getRenderer()) : new ActivityUserProfileFragment(this.pluginAccessor, (GadgetRequestContextFactory)ComponentAccessor.getOSGiComponentInstanceOfType(GadgetRequestContextFactory.class), this.i18nFactory);
        if (fragment.showFragment(profileUser, currentUser)) {
            params.put("fragmentId", fragment.getId());
            params.put("fragmentHtml", fragment.getFragmentHtml(profileUser, currentUser));
        }
        params.put("pluggablePanelFragmentHtml", this.pluggablePanel.getFragmentHtml(profileUser, currentUser));
        return params;
    }

    private List<SimpleLink> getFilters(ApplicationUser profileUser, ApplicationUser currentUser) {
        I18nHelper i18n = this.i18nFactory.getInstance(currentUser);
        boolean isResolutionAvailable = this.isResolutionFieldAvailable(currentUser);
        ArrayList links = Lists.newArrayList();
        links.add(this.getAssigned(profileUser, i18n));
        if (isResolutionAvailable) {
            links.add(this.getAssignedAndOpen(profileUser, i18n));
        }
        links.add(this.getInProgress(profileUser, i18n));
        links.add(this.getReported(profileUser, i18n));
        if (isResolutionAvailable) {
            links.add(this.getReportedAndOpen(profileUser, i18n));
        }
        if (profileUser.equals((Object)currentUser)) {
            if (this.isVotingEnabled()) {
                links.add(this.getVoted(i18n));
                if (isResolutionAvailable) {
                    links.add(this.getVotedAndOpen(i18n));
                }
            }
            if (this.isWatchingEnabled()) {
                links.add(this.getWatched(i18n));
                if (isResolutionAvailable) {
                    links.add(this.getWatchedAndOpen(i18n));
                }
            }
        }
        return links;
    }

    private SimpleLink getAssignedAndOpen(ApplicationUser profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().unresolved();
        ApplicationUser currentUser = this.context.getUser();
        if (profileUser.equals((Object)currentUser)) {
            builder.and().assigneeIsCurrentUser();
        } else {
            builder.and().assignee().eq(profileUser.getName());
        }
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("ass_open", i18n.getText("userfilters.assigned.and.open"), i18n.getText("userfilters.assigned.and.open.desc"), null, null, null, url, null);
    }

    private SimpleLink getAssigned(ApplicationUser profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
        ApplicationUser currentUser = this.context.getUser();
        if (profileUser.equals((Object)currentUser)) {
            builder.assigneeIsCurrentUser();
        } else {
            builder.assignee().eq(profileUser.getName());
        }
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("ass", i18n.getText("userfilters.assigned"), i18n.getText("userfilters.assigned.desc"), null, null, null, url, null);
    }

    private SimpleLink getInProgress(ApplicationUser profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().status(new String[]{"3"});
        ApplicationUser currentUser = this.context.getUser();
        if (profileUser.equals((Object)currentUser)) {
            builder.and().assigneeIsCurrentUser();
        } else {
            builder.and().assignee().eq(profileUser.getName());
        }
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("ass_inprog", i18n.getText("userfilters.assigned.and.inprogress"), i18n.getText("userfilters.assigned.and.inprogress.desc"), null, null, null, url, null);
    }

    private SimpleLink getReportedAndOpen(ApplicationUser profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().unresolved();
        ApplicationUser currentUser = this.context.getUser();
        if (profileUser.equals((Object)currentUser)) {
            builder.and().reporterIsCurrentUser();
        } else {
            builder.and().reporter().eq(profileUser.getName());
        }
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("rep_open", i18n.getText("userfilters.reported.and.open"), i18n.getText("userfilters.reported.and.open.desc"), null, null, null, url, null);
    }

    private SimpleLink getReported(ApplicationUser profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
        ApplicationUser currentUser = this.context.getUser();
        if (profileUser.equals((Object)currentUser)) {
            builder.reporterIsCurrentUser();
        } else {
            builder.reporter().eq(profileUser.getName());
        }
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("rep", i18n.getText("userfilters.reported"), i18n.getText("userfilters.reported.desc"), null, null, null, url, null);
    }

    private boolean isVotingEnabled() {
        return this.applicationProperties.getOption("jira.option.voting");
    }

    private boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    private boolean isResolutionFieldAvailable(ApplicationUser user) {
        return this.fieldVisibiltyManager.isFieldVisible(user, "resolution");
    }

    private SimpleLink getVoted(I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().issueInVotedIssues();
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("voted", i18n.getText("userfilters.voted"), i18n.getText("userfilters.voted.desc"), null, null, null, url, null);
    }

    private SimpleLink getVotedAndOpen(I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().issueInVotedIssues().and().unresolved();
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("voted_open", i18n.getText("userfilters.voted.and.open"), i18n.getText("userfilters.voted.and.open.desc"), null, null, null, url, null);
    }

    private SimpleLink getWatched(I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().issueInWatchedIssues();
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("watched", i18n.getText("userfilters.watched"), i18n.getText("userfilters.watched.desc"), null, null, null, url, null);
    }

    private SimpleLink getWatchedAndOpen(I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().issueInWatchedIssues().and().unresolved();
        String issueSearchPath = this.searchService.getIssueSearchPath(this.context.getUser(), SearchService.IssueSearchParameters.builder().query(builder.buildQuery()).build());
        String url = this.requestContext.getBaseUrl() + issueSearchPath;
        return new SimpleLinkImpl("watched_open", i18n.getText("userfilters.watched.and.open"), i18n.getText("userfilters.watched.and.open.desc"), null, null, null, url, null);
    }
}

