/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.RealClock;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.utils.ConstantTimeComparison;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PasswordResetTokenBuilder {
    private static final Logger log = LoggerFactory.getLogger(PasswordResetTokenBuilder.class);
    private static final int TOKEN_EXPIRY_HOURS = 24;
    private static final String PASSWORD_RESET_REQUEST_TOKEN = "password.reset.request.token";
    private static final String PASSWORD_RESET_REQUEST_EXPIRY = "password.reset.request.expiry";
    private final Clock clock;
    private final CrowdService crowdService;

    PasswordResetTokenBuilder(CrowdService crowdService) {
        this(RealClock.getInstance(), crowdService);
    }

    PasswordResetTokenBuilder(Clock clock, CrowdService crowdService) {
        this.clock = clock;
        this.crowdService = crowdService;
    }

    UserUtil.PasswordResetToken generateToken(final ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        final String token = this.genSecureToken();
        final long expiryTime = this.genExpiryTime();
        this.recordToken(user, token, expiryTime);
        return new UserUtil.PasswordResetToken(){

            public ApplicationUser getUser() {
                return user;
            }

            public String getToken() {
                return token;
            }

            public int getExpiryHours() {
                return 24;
            }

            public long getExpiryTime() {
                return expiryTime;
            }
        };
    }

    UserUtil.PasswordResetTokenValidation.Status validateToken(ApplicationUser user, String token) {
        Assertions.notNull((String)"user", (Object)user);
        String storedToken = this.getStoredToken(user);
        if (storedToken == null || token == null) {
            return UserUtil.PasswordResetTokenValidation.Status.EXPIRED;
        }
        if (ConstantTimeComparison.isEqual((String)storedToken, (String)token)) {
            return UserUtil.PasswordResetTokenValidation.Status.OK;
        }
        return UserUtil.PasswordResetTokenValidation.Status.UNEQUAL;
    }

    void resetToken(ApplicationUser user) {
        this.recordTokenImpl(user, null, null);
    }

    private String genSecureToken() {
        return DefaultSecureTokenGenerator.getInstance().generateToken();
    }

    private String getStoredToken(ApplicationUser user) {
        UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getName());
        String expiryStr = userWithAttributes.getValue(PASSWORD_RESET_REQUEST_EXPIRY);
        if (expiryStr == null) {
            return null;
        }
        long expiry = Long.parseLong(expiryStr);
        if (this.now().getMillis() > expiry) {
            return null;
        }
        return userWithAttributes.getValue(PASSWORD_RESET_REQUEST_TOKEN);
    }

    private long genExpiryTime() {
        return this.now().plusHours(24).getMillis();
    }

    private DateTime now() {
        return new DateTime(this.clock.getCurrentDate().getTime(), DateTimeZone.UTC);
    }

    private void recordToken(ApplicationUser user, String token, long expiryTime) {
        this.recordTokenImpl(user, token, String.valueOf(expiryTime));
    }

    private void recordTokenImpl(ApplicationUser user, String token, String expiryTime) {
        try {
            if (token == null) {
                this.crowdService.removeUserAttribute(user.getDirectoryUser(), PASSWORD_RESET_REQUEST_EXPIRY);
                this.crowdService.removeUserAttribute(user.getDirectoryUser(), PASSWORD_RESET_REQUEST_TOKEN);
            } else {
                this.crowdService.setUserAttribute(user.getDirectoryUser(), PASSWORD_RESET_REQUEST_EXPIRY, expiryTime);
                this.crowdService.setUserAttribute(user.getDirectoryUser(), PASSWORD_RESET_REQUEST_TOKEN, token);
            }
        }
        catch (OperationNotPermittedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

